#include <GUIConstantsEx.au3>
#include <GDIPlus.au3>

$sFile = FileOpenDialog("Select an image", "", "Images (*.jpg;*.bmp;*.png;*.gif;*.tif)")
If @error Then Exit

_GDIPlus_Startup()
Global $hImage = _GDIPlus_ImageLoadFromFile($sFile)
If Not $hImage Then
    _GDIPlus_Shutdown()
    Exit
EndIf
Global $iW = _GDIPlus_ImageGetWidth($hImage), $iH = _GDIPlus_ImageGetHeight($hImage)
Global $hGUI = GUICreate("GDI+ Test", $iW, $iH) ;no check when image is larger than screen!
GUISetState()
Global $hGfx = _GDIPlus_GraphicsCreateFromHWND($hGUI) ;only for display purposes
Global $hBitmap = _GDIPlus_BitmapCreateFromGraphics($iW, $iH, $hGfx)
Global $hImgContext = _GDIPlus_ImageGetGraphicsContext($hBitmap) ;this is needed to copy the image to the bitmap and draw on it
_GDIPlus_GraphicsDrawImageRect($hImgContext, $hImage, 0, 0, $iW, $iH) ;copy loaded image to bitmap (not display in GUI yet)
Global $hBrush = _GDIPlus_BrushCreateSolid(0xFFFF0000) ;create a brush AARRGGBB
_GDIPlus_GraphicsFillRect($hImgContext, $iW / 2 - 10, 0, 20, $iH, $hBrush) ;draw filled rectangle of the image vertically
_GDIPlus_GraphicsFillRect($hImgContext, 0, $iH / 2 - 10, $iW, 20, $hBrush) ;draw filled rectangle of the image horizontally

_GDIPlus_GraphicsDrawImageRect($hGfx, $hBitmap, 0, 0, $iW, $iH) ;copy modified image to graphic handle -> display it in the GUI

_GDIPlus_ImageSaveToFile($hBitmap, @ScriptDir & "\Modified.jpg")

;clean up resources
_GDIPlus_BrushDispose($hBrush)
_GDIPlus_GraphicsDispose($hImgContext)
_GDIPlus_GraphicsDispose($hGfx)
_GDIPlus_BitmapDispose($hBitmap)
_GDIPlus_ImageDispose($hImage)
_GDIPlus_Shutdown()
Do
Until GUIGetMsg() = $GUI_EVENT_CLOSE
GUIDelete()
ShellExecute(@ScriptDir & "\Modified.jpg")
Exit