#include <GuiConstantsEx.au3>
#include <GDIPlus.au3>

#include <WinAPI.au3>

#include <ScreenCapture.au3>

#include <ButtonConstants.au3>

#include <StaticConstants.au3>

#include <WindowsConstants.au3>

#include <EditConstants.au3>

#include <Color.au3>

#include <Array.au3>

#include <Misc.au3>

; http://www.autoitscript.com/forum/index.ph...st&p=660196

Opt("MouseCoordMode", 0) ;1=absolute, 0=relative, 2=client

Global $sGUITitle = "Ctrl+Left Click to Clpbrd: Alt+Left to Image", $z1 = 28, $SIZEX = 256, $SIZEY = 300, $GUIZoom, $hGraphic

Global $zoomX = Int($SIZEX / $z1), $zoomY = Int(($SIZEY - 44) / $z1), $DeskDC, $MyDC, $hPen, $hColLab, $source, $hBitmap1

Global $hGUI1, $hGUI2, $OWin, $CMWin, $hGraphic1, $hGraphic2, $hBitmap, $GuiSizeX, $GuiSizeY, $PathFile, $checkCN, $sColor

Global $aInputData[6][19] = [["$OWin", 40, 60, "$GuiSizeX-80", "$GuiSizeY-120", "0xE0E0E0FF", "0x000000FF", 30, "$OWin", 0, 0, "$GuiSizeX", _

"$GuiSizeY", "$CMWin", 40, 60, "$GuiSizeX-80", "$GuiSizeY-120", _

"Changes all near white colours in a rectanular area to fully opaque black," & @CRLF & "using range parameter"], _

["$OWin", 0, 0, "$GuiSizeX", "$GuiSizeY", "0xE0E0E0FF", "Default", 30, "$CMWin", 0, 0, "$GuiSizeX", "$GuiSizeY", "", "", "", "", "", _

"Changes all near white colours in image to fully transparent," & @CRLF & "using range parameter"], _

["$OWin", "", "", "", "", "", "", "", "$CMWin", 0, 0, "$GuiSizeX", "$GuiSizeY", "", "", "", "", "", _

"Changes the background colour at point x=1, y=1 of image to fully transparent," & @CRLF & "using Default parameters."], _

["$OWin", 0, 0, "$GuiSizeX", "$GuiSizeY", "(.{6}00) ", "0x00FFFFA0", "", "$CMWin", 0, 0, "$GuiSizeX", "$GuiSizeY", "", "", "", "", "", _

"Changes all existing transparent colours to (100 * 0xA0/0xFF) percent opaque yellow." & @CRLF & _

" Range auto-set to 0. Format of $iColSrch is 0xBBGGRRAA AA is Alpha channel." & @CRLF & _

" 00 - completely transparent, FF- fully opaque."], _

["$OWin", 0, 0, "$GuiSizeX", "$GuiSizeY", "0xE0FFFFFF", "0x000000FF", 30, "$CMWin", 0, 0, "$GuiSizeX", "$GuiSizeY", "", "", "", "", "", _

"Changes existing colours to another colour." & @CRLF & "Colour format is always hex 0xBBGGRRAA"], _

["$OWin", 0, 0, "$GuiSizeX", "$GuiSizeY", "([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})(FF)", "${3}${2}${1}${4}", "", _

"$CMWin", 0, 0, "$GuiSizeX", "$GuiSizeY", "", "", "", "", "", _

"Swaps all existing blue (BB) and red (RR) channnels within each pixel." & @CRLF & _

" Colour format is 0xBBGGRRAA AA is Alpha channel (transparency." & @CRLF & _

" An example of using a regular expression."]]

Global $Tips[8] = ["Image Handle" & @CRLF & "$OWin - Original Window" & @CRLF & "$CMWin - Colour Modified Window", _

"Window Top Left X Pos", "Window Top Left Y Pos", "Variable $GuiSizeX" & @CRLF & "is Original window Width.", _

"Variable $GuiSizeY" & @CRLF & "is Original window Height", "A colour or RegExp of a colour to search for." & @CRLF & _

"Colour format is hex 0xBBGGRRAA", "Replace with", "Range"]

Local $Radio[6], $Input[19], $Label[19], $Err = 0, $aPosClient

Local $CtrlWidths[18] = [83, 41, 45, 113, 113, 113, 113, 33, 77, 47, 47, 107, 107, 77, 47, 47, 107, 107]

Local $LabelText[8] = ["Image", "Left Pos", "Top Pos", "GUI Width", "GUI Height", "Search For", "Replace with", "Range"]

$Form1_1 = GUICreate("Modify Pixels", 779, 321, @DesktopWidth - 779, 30, -1, $WS_EX_TOPMOST)

Local $Grap = GUICtrlCreateGraphic(0, 0, 779, 321)

For $x = 1 To 321

$hue = Color_SetHSL(Int($x / 2))

GUICtrlSetGraphic(-1, $GUI_GR_MOVE, 1, $x)

GUICtrlSetGraphic(-1, $GUI_GR_COLOR, "0x" & Hex($hue, 6))

GUICtrlSetGraphic(-1, $GUI_GR_LINE, 779, $x)

Next

GUICtrlSetState($Grap, $GUI_DISABLE)

$Group1 = GUICtrlCreateGroup("ImageColorToTransparent() Function Parameters", 8, 8, 761, 73)

GUICtrlSetBkColor(-1, 0xEFC1BA)

$Input[0] = GUICtrlCreateInput("$OWin", 16, 30, $CtrlWidths[0], 24)

GUICtrlSetTip(-1, $Tips[0])

GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")

$Label[0] = GUICtrlCreateLabel($LabelText[0], 16, 56, $CtrlWidths[0], 20)

GUICtrlSetBkColor(-1, 0xEFC1BA)

GUICtrlSetFont(-1, 10, 400, 0, "MS Sans Serif")

For $num = 1 To 7

$CtrlPos = ControlGetPos("Modify Pixels", "", $Input[$num - 1])

$Input[$num] = GUICtrlCreateInput("", $CtrlPos[0] + $CtrlWidths[$num - 1] + 12, $CtrlPos[1], $CtrlWidths[$num], 24)

GUICtrlSetTip(-1, $Tips[$num])

GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")

$Label[$num] = GUICtrlCreateLabel($LabelText[$num], $CtrlPos[0] + $CtrlWidths[$num - 1] + 12, $CtrlPos[1] + 26, $CtrlWidths[$num] + 9, 20)

GUICtrlSetBkColor(-1, 0xEFC1BA)

GUICtrlSetFont(-1, 10, 400, 0, "MS Sans Serif")

Next

GUICtrlCreateGroup("", -99, -99, 1, 1)

$Group2 = GUICtrlCreateGroup("_GDIPlus_GraphicsDrawImageRect() Function Parameters", 8, 84, 440, 73)

GUICtrlSetBkColor(-1, 0xEBFFBA)

$Input[8] = GUICtrlCreateInput("$OWin", 16, 106, $CtrlWidths[8], 24)

GUICtrlSetTip(-1, $Tips[0])

GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")

$Label[8] = GUICtrlCreateLabel($LabelText[0], 16, 132, $CtrlWidths[8], 20)

GUICtrlSetBkColor(-1, 0xEBFFBA)

GUICtrlSetFont(-1, 10, 400, 0, "MS Sans Serif")

For $num = 9 To 12

$CtrlPos = ControlGetPos("Modify Pixels", "", $Input[$num - 1])

$Input[$num] = GUICtrlCreateInput("", $CtrlPos[0] + $CtrlWidths[$num - 1] + 8, $CtrlPos[1], $CtrlWidths[$num], 24)

GUICtrlSetTip(-1, $Tips[$num - 8])

GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")

$Label[$num] = GUICtrlCreateLabel($LabelText[$num - 8], $CtrlPos[0] + $CtrlWidths[$num - 1] + 8, $CtrlPos[1] + 26, $CtrlWidths[$num] + 5, 20)

GUICtrlSetBkColor(-1, 0xEBFFBA)

GUICtrlSetFont(-1, 10, 400, 0, "MS Sans Serif")

Next

GUICtrlCreateGroup("", -99, -99, 1, 1)

$Group3 = GUICtrlCreateGroup("Second _GraphicsDrawImageRect() Function Parameters", 8, 160, 440, 73)

GUICtrlSetBkColor(-1, 0xBAEFBA)

$Input[13] = GUICtrlCreateInput("$OWin", 16, 182, $CtrlWidths[13], 24)

GUICtrlSetTip(-1, $Tips[0])

GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")

$Label[13] = GUICtrlCreateLabel($LabelText[0], 16, 208, $CtrlWidths[13], 20)

GUICtrlSetBkColor(-1, 0xBAEFBA)

GUICtrlSetFont(-1, 10, 400, 0, "MS Sans Serif")

For $num = 14 To 17

$CtrlPos = ControlGetPos("Modify Pixels", "", $Input[$num - 1])

$Input[$num] = GUICtrlCreateInput("", $CtrlPos[0] + $CtrlWidths[$num - 1] + 8, $CtrlPos[1], $CtrlWidths[$num], 24)

GUICtrlSetTip(-1, $Tips[$num - 13])

GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")

$Label[$num] = GUICtrlCreateLabel($LabelText[$num - 13], $CtrlPos[0] + $CtrlWidths[$num - 1] + 8, $CtrlPos[1] + 26, $CtrlWidths[$num] + 5, 20)

GUICtrlSetBkColor(-1, 0xBAEFBA)

GUICtrlSetFont(-1, 10, 400, 0, "MS Sans Serif")

Next

GUICtrlCreateGroup("", -99, -99, 1, 1)

$Group4 = GUICtrlCreateGroup("Pick Image Source", 571, 84, 129, 90)

GUICtrlSetBkColor(-1, 0xA6CAF0)

$Radio6 = GUICtrlCreateRadio("Screen Capture", 579, 108, 113, 17)

GUICtrlSetBkColor(-1, 0xA6CAF0)

GUICtrlSetState(-1, $GUI_CHECKED)

$Radio7 = GUICtrlCreateRadio("Load from File", 579, 129, 113, 17)

GUICtrlSetBkColor(-1, 0xA6CAF0)

$Radio1 = GUICtrlCreateRadio("Use Modified Image", 579, 150, 113, 17)

GUICtrlSetBkColor(-1, 0xA6CAF0)

GUICtrlCreateGroup("", -99, -99, 1, 1)

$checkCN = GUICtrlCreateCheckbox("Select Colour", 579, 177, 113, 17, -1, $BS_NOTIFY)

GUICtrlSetBkColor(-1, 0xBAEFCA)

GUICtrlSetState($checkCN, $GUI_UNCHECKED)

$Group5 = GUICtrlCreateGroup("Select Example", 457, 84, 105, 148)

GUICtrlSetBkColor(-1, 0xA0FFA0)

For $x = 0 To UBound($Radio) - 1

$Radio[$x] = GUICtrlCreateRadio("Example " & $x + 1, 464, 105 + $x * 21, 89, 17)

GUICtrlSetBkColor(-1, 0xA0FFA0)

Next

GUICtrlSetState($Radio[0], $GUI_CHECKED)

GUICtrlSetData($Radio[uBound($Radio) - 1], "RegExp eg.")

GUICtrlSetBkColor(-1, 0xA0FFA0)

GUICtrlCreateGroup("", -99, -99, 1, 1)

$Button1 = GUICtrlCreateButton("Go", 706, 90, 65, 41)

GUICtrlSetFont(-1, 12, 800, 0, "MS Sans Serif")

$Button2 = GUICtrlCreateButton("Exit", 706, 185, 65, 41)

GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")

GUICtrlSetBkColor(-1, 0xFF0000)

$Input[18] = GUICtrlCreateEdit("", 8, 240, 753, 72, $ES_MULTILINE);, BitOR($ES_AUTOVSCROLL,$ES_AUTOHSCROLL,$WS_HSCROLL,$WS_VSCROLL))

GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")

$Button3 = GUICtrlCreateButton("Save Image", 706, 137, 65, 41)

$Label1 = GUICtrlCreateLabel("Process Time", 576, 197, 102, 17)

GUICtrlSetBkColor(-1, 0xF8F8F8)

$Label2 = GUICtrlCreateLabel("", 576, 213, 102, 20)

GUICtrlSetBkColor(-1, 0xF8F8F8)

GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")

GUISetState(@SW_SHOW)

;WinWaitActive("Modify Pixels")

_GDIPlus_Startup()

GUICtrlSetState($Group1, $GUI_HIDE)

GUIRegisterMsg(0xF, "MY_PAINT"); Register PAINT-Event 0x000F = $WM_PAINT (WindowsConstants.au3)

GUIRegisterMsg(0x85, "MY_PAINT") ; $WM_NCPAINT = 0x0085 (WindowsConstants.au3)Restore after Minimize.

$source = "Screen"

ControlClick("Modify Pixels", "", $Radio[0])

Sleep(10)

_Main("Screen");, "init")

;ControlClick("Modify Pixels", "", $Radio[0])

ControlClick("Modify Pixels", "", $Button1)

While 1

$nMsg = GUIGetMsg()

Switch $nMsg

Case $GUI_EVENT_CLOSE, $Button2

ExitLoop

Case $checkCN

If BitAND(GUICtrlRead($checkCN), $GUI_CHECKED) = 1 Then

$GUIZoom = GUICreate($sGUITitle, $SIZEX, $SIZEY, @DesktopWidth - $SIZEX - 5, @DesktopHeight - $SIZEY - 50, _

$WS_CLIPSIBLINGS, $WS_EX_TOPMOST)

GUICtrlSetState($checkCN, $GUI_CHECKED)

WinSetTrans($sGUITitle, "", 254)

$hColLab = GUICtrlCreateLabel("This is a label for colours.", 0, 0, 254, 39)

GUISetBkColor(0xFFFFA0)

GUISetState()

$DeskDC = _WinAPI_GetDC(0)

$MyDC = _WinAPI_GetDC($GUIZoom)

$hGraphic = _GDIPlus_GraphicsCreateFromHWND($GUIZoom)

$hPen = _GDIPlus_PenCreate()

Else

GUICtrlSetState($checkCN, $GUI_UNCHECKED)

GUIDelete($GUIZoom)

_WinAPI_ReleaseDC(0, $DeskDC)

_WinAPI_ReleaseDC($GUIZoom, $MyDC)

EndIf

Case $Radio1

If BitAND(GUICtrlRead($Radio1), $GUI_CHECKED) = 1 Then

If Execute(GUICtrlRead($Input[13])) <> "" Then

Local $hImageS = _GDIPlus_BitmapCloneArea($OWin, 0, 0, $GuiSizeX, $GuiSizeY, $GDIP_PXF32ARGB)

Local $hGraphicS = _GDIPlus_ImageGetGraphicsContext($hImageS)

_GDIPlus_GraphicsDrawImage($hGraphicS, $CMWin, GUICtrlRead($Input[14]), GUICtrlRead($Input[15]))

_GDIPlus_ImageDispose($OWin)

$OWin = _GDIPlus_BitmapCloneArea($hImageS, 0, 0, $GuiSizeX, $GuiSizeY, $GDIP_PXF32ARGB)

_GDIPlus_GraphicsDispose($hGraphicS)

_GDIPlus_ImageDispose($hImageS)

Else

_GDIPlus_ImageDispose($OWin)

$OWin = _GDIPlus_BitmapCloneArea($CMWin, 0, 0, $GuiSizeX, $GuiSizeY, $GDIP_PXF32ARGB)

EndIf

EndIf

Case $Radio[0] To $Radio[5]

For $num = 0 To 17

GUICtrlSetData($Input[$num], $aInputData[$nMsg - $Radio[0]][$num])

Next

GUICtrlSetData($Input[18], "$GuiSizeX = " & $GuiSizeX & "; $GuiSizeY = " & $GuiSizeY & @CRLF & _

$aInputData[$nMsg - $Radio[0]][18])

Case $Button1

$Err = 0

;ConsoleWrite("Cleanup $Radio1 " & BitAND(GUICtrlRead($Radio1), $GUI_CHECKED) & @CRLF)

If BitAND(GUICtrlRead($Radio6), $GUI_CHECKED) = 1 Then $source = "Screen"

If BitAND(GUICtrlRead($Radio1), $GUI_CHECKED) = 1 Then $source = "ModFile"

If BitAND(GUICtrlRead($Radio7), $GUI_CHECKED) = 1 Then

$source = "File"

Local $PathFile = FileOpenDialog("Choose a File", @ScriptDir & "\", "Images (*.jpg;*.bmp;*.png;*.gif)|All Files (*.*)", 3)

If @error Then $Err = 1

EndIf

If $Err <> 1 Then CleanUpAll()

If $Err <> 1 Then _Main($source)

Case $Button3

$var = FileSaveDialog("Choose a name.", @ScriptDir, "Images (*.bmp;*.jpg;*.png;*.gif)|All files (*.*)", 16, "ColourModify.png")

If Not @error Then

If Execute(GUICtrlRead($Input[13])) <> "" Then

Local $hImageS = _GDIPlus_BitmapCloneArea($OWin, 0, 0, $GuiSizeX, $GuiSizeY, $GDIP_PXF32ARGB)

Local $hGraphicS = _GDIPlus_ImageGetGraphicsContext($hImageS)

_GDIPlus_GraphicsDrawImage($hGraphicS, $CMWin, GUICtrlRead($Input[14]), GUICtrlRead($Input[15]))

_GDIPlus_ImageSaveToFile($hImageS, $var)

_GDIPlus_GraphicsDispose($hGraphicS)

_GDIPlus_ImageDispose($hImageS)

Else

_GDIPlus_ImageSaveToFile($CMWin, $var)

EndIf

ShellExecute($var)

EndIf

EndSwitch

If BitAND(GUICtrlRead($checkCN), $GUI_CHECKED) = 1 Then

Opt("MouseCoordMode", 1) ;1=absolute, 0=relative, 2=client

$aPos = MouseGetPos()

Sleep(50)

_WinAPI_StretchBlt($MyDC, 0, 44, $SIZEX, $SIZEY - 44, $DeskDC, $aPos[0] + 1 - ($zoomX / 2), $aPos[1] + 1 - ($zoomY / 2), $zoomX, $zoomY, $SRCCOPY)

_GDIPlus_GraphicsDrawLine($hGraphic, 128, 45, 128, $SIZEY - 1, $hPen)

_GDIPlus_GraphicsDrawLine($hGraphic, 1, 172, 255, 172, $hPen)

$sColor = GetPixel(0, $aPos[0], $aPos[1])

Opt("MouseCoordMode", 2) ;1=absolute, 0=relative, 2=client

$aPosClient = MouseGetPos()

Opt("MouseCoordMode", 1) ;1=absolute, 0=relative, 2=client

$sAWinTte = WinGetTitle("")

GUICtrlSetData($hColLab, "0xBBGGRR colour is " & $sColor & " ; X, Y : " & $aPosClient[0] & ", " & $aPosClient[1] & @CRLF & _

"Active Win Title : " & _Iif(StringLen($sAWinTte) > 35, StringLeft($sAWinTte, 13) & "..." & StringRight($sAWinTte, 18), _

$sAWinTte) & @CRLF & _

"Screen X, Y : " & $aPos[0] & ", " & $aPos[1])

Opt("MouseCoordMode", 0) ;1=absolute, 0=relative, 2=client

EndIf

If IsPressed("01") And IsPressed("12") Then ;Left click + Alt key

Do

Until Not IsPressed("01")

Local $sPutCol

Local $sOnCl = ClipGet()

If StringLeft($sOnCl, 2) = "0x" Then

$sPutCol = "0x" & StringRight($sOnCl, 2) & StringMid($sOnCl, 7, 2) & StringMid($sOnCl, 5, 2) & StringMid($sOnCl, 3, 2)

Else

$sPutCol = "0xFFFF0000"

EndIf

Opt("MouseCoordMode", 2) ;1=absolute, 0=relative, 2=client

$aPos = MouseGetPos()

if WinGetTitle("") = "Original" or WinGetTitle("") = "Colour Modified" then

DllCall($ghGDIPDll, "int", "GdipBitmapSetPixel", "hwnd", $OWin, "int", $aPos[0], "int", $aPos[1], "dword", $sPutCol)

;if WinGetTitle("") = "Colour Modified" then _

DllCall($ghGDIPDll, "int", "GdipBitmapSetPixel", "hwnd", $CMWin, "int", $aPos[0], "int", $aPos[1], "dword", $sPutCol)

EndIf

Opt("MouseCoordMode", 1) ;1=absolute, 0=relative, 2=client

If WinGetHandle("") = WinGetHandle("Colour Modified") or WinGetHandle("") = WinGetHandle("Original") Then

_GDIPlus_GraphicsDrawImageRect($hGraphic1, $OWin, 0, 0, $GuiSizeX, $GuiSizeY)

If GUICtrlRead($Input[13]) <> "" Or GUICtrlRead($Input[14]) <> ""Then

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[8])), GUICtrlRead($Input[9]), GUICtrlRead($Input[10]), _

Execute(GUICtrlRead($Input[11])), Execute(GUICtrlRead($Input[12])))

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[13])), GUICtrlRead($Input[14]), GUICtrlRead($Input[15]), _

Execute(GUICtrlRead($Input[16])), Execute(GUICtrlRead($Input[17])))

Else

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[8])), GUICtrlRead($Input[9]), GUICtrlRead($Input[10]), _

Execute(GUICtrlRead($Input[11])), Execute(GUICtrlRead($Input[12])))

EndIf

EndIf

EndIf

If IsPressed("01") And IsPressed("11") Then ;Left click + Ctrl key

Do

Until Not IsPressed("01")

If BitAND(GUICtrlRead($checkCN), $GUI_CHECKED) = 1 Then ClipPut($sColor & "FF")

;ConsoleWrite('$sColor & "FF = "' & $sColor & "FF" & @CRLF)

EndIf

WEnd

_GDIPlus_Shutdown()

Func _Main($source)

If $source = "File" Then

$OWin = _GDIPlus_ImageLoadFromFile($PathFile) ; @DesktopDir & "\heart.png")

$GuiSizeX = _GDIPlus_ImageGetWidth($OWin)

$GuiSizeY = _GDIPlus_ImageGetHeight($OWin)

;ConsoleWrite("$GuiSizeX = " & $GuiSizeX & @CRLF & "$GuiSizeY = " & $GuiSizeY & @CRLF)

ElseIf $source = "Screen" Then

; Capture top left corner of the screen

$GuiSizeX = 300

$GuiSizeY = 400

$hBitmap = _ScreenCapture_Capture("", 0, 0, $GuiSizeX, $GuiSizeY)

$OWin = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)

EndIf

; Create a GUI for the original image

$hGUI1 = GUICreate("Original", $GuiSizeX + 10, $GuiSizeY + 30, 0, 0, $WS_CLIPSIBLINGS)

GUISetState()

; Create a GUI for the colour modified image

$hGUI2 = GUICreate("Colour Modified", $GuiSizeX + 10, $GuiSizeY + 30, 0, $GuiSizeY + 30, $WS_CLIPSIBLINGS)

GUISetState()

; Draw original image

$hGraphic1 = _GDIPlus_GraphicsCreateFromHWND($hGUI1)

;_GDIPlus_GraphicsDrawImage($hGraphic1, $OWin 0, 0)

_GDIPlus_GraphicsDrawImageRect($hGraphic1, $OWin, 0, 0, $GuiSizeX, $GuiSizeY)

$hGraphic2 = _GDIPlus_GraphicsCreateFromHWND($hGUI2)

;Read all parameters in input boxes $ calls functions

$CMWin = ImageColorToTransparent(Execute(GUICtrlRead($Input[0])), GUICtrlRead($Input[1]), GUICtrlRead($Input[2]), _

Execute(GUICtrlRead($Input[3])), Execute(GUICtrlRead($Input[4])), GUICtrlRead($Input[5]), _

GUICtrlRead($Input[6]), GUICtrlRead($Input[7]));

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[8])), GUICtrlRead($Input[9]), GUICtrlRead($Input[10]), _

Execute(GUICtrlRead($Input[11])), Execute(GUICtrlRead($Input[12])))

If Execute(GUICtrlRead($Input[13])) > 0 And GUICtrlRead($Input[14]) <> "" And GUICtrlRead($Input[15]) <> "" And _

Execute(GUICtrlRead($Input[16])) > 0 And Execute(GUICtrlRead($Input[17])) > 0 Then _

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[13])), _

GUICtrlRead($Input[14]), GUICtrlRead($Input[15]), _

Execute(GUICtrlRead($Input[16])), Execute(GUICtrlRead($Input[17])))

; ========> End of Examples ========================================================

_WinAPI_RedrawWindow($hGUI1)

_WinAPI_InvalidateRect($hGUI2)

_GDIPlus_GraphicsDrawImageRect($hGraphic1, $OWin, 0, 0, $GuiSizeX, $GuiSizeY)

If GUICtrlRead($Input[14]) > 0 Or GUICtrlRead($Input[15]) > 0 Then

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[8])), GUICtrlRead($Input[9]), GUICtrlRead($Input[10]), _

Execute(GUICtrlRead($Input[11])), Execute(GUICtrlRead($Input[12])))

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[13])), GUICtrlRead($Input[14]), GUICtrlRead($Input[15]), _

Execute(GUICtrlRead($Input[16])), Execute(GUICtrlRead($Input[17])))

Else

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[8])), GUICtrlRead($Input[9]), GUICtrlRead($Input[10]), _

Execute(GUICtrlRead($Input[11])), Execute(GUICtrlRead($Input[12])))

EndIf

Return

EndFunc ;==>_Main

Func CleanUpAll()

; Release resources

If $hBitmap <> "" Then _WinAPI_DeleteObject($hBitmap)

_GDIPlus_GraphicsDispose($hGraphic1)

_GDIPlus_GraphicsDispose($hGraphic2)

If BitAND(GUICtrlRead($Radio1), $GUI_CHECKED) = 1 Then

_GDIPlus_ImageDispose($CMWin)

Else

_GDIPlus_ImageDispose($OWin)

_GDIPlus_ImageDispose($CMWin)

EndIf

GUIDelete($hGUI1)

GUIDelete($hGUI2)

Return

EndFunc ;==>CleanUpAll

Func ImageColorToTransparent($hImage2, $iStartPosX = 0, $iStartPosY = 0, $iGuiSizeX = Default, $iGuiSizeY = Default, _

$iColSrch = Default, $iColNew = Default, $Range = 0)

Local $Reslt, $width, $height, $stride, $format, $Scan0, $v_Buffer, $v_Value, $iIW, $iIH

Local $iColorSrch, $Timer, $v_BufferA, $AllPixels, $sREResult1, $iRnge, $blue, $sBlueString, $green, $sGreenString

Local $red, $sRedString, $sSearch, $iColorNew

$iIW = _GDIPlus_ImageGetWidth($hImage2)

$iIH = _GDIPlus_ImageGetHeight($hImage2)

If $iGuiSizeX = Default Or $iGuiSizeX = "" Then $iGuiSizeX = $GuiSizeX

;ConsoleWrite("$iGuiSizeX = " & $iGuiSizeX & @CRLF)

If $iGuiSizeY = Default Or $iGuiSizeY = "" Then $iGuiSizeY = $GuiSizeY

;ConsoleWrite("$iGuiSizeY = " & $iGuiSizeY & @CRLF)

$hBitmap1 = _GDIPlus_BitmapCloneArea($hImage2, $iStartPosX, $iStartPosY, $iGuiSizeX, $iGuiSizeY, $GDIP_PXF32ARGB); $GDIP_PXF16RGB555);

; Transparent color

If $iColSrch = Default Or $iColSrch = "" Then

$iColSrch = GDIPlus_BitmapGetPixel($hBitmap1, 1, 1)

; Convert 0xAARRGGBB to 0xBBGGRRAA

$iColSrch = "0x" & Hex(BitAND(0x000000FF, $iColSrch), 2) & Hex(BitShift(BitAND(0x0000FF00, $iColSrch), 8), 2) & _

Hex(BitShift(BitAND(0x00FF0000, $iColSrch), 16), 2) & Hex(BitShift(BitAND(0xFF000000, $iColSrch), 24), 2)

$Range = 0

EndIf

If StringRegExp($iColSrch, "([][)(?#^{}\\:|,.])", 0) = 1 Then

$iColorSrch = $iColSrch

$Range = 0

Else

;Pixel format from bitmap in Hexidecimal BBGGRRAA format. So, convert to that format

$iColorSrch = $iColSrch ;BBGGRRAA format

EndIf

;ConsoleWrite("$iColSrch = " & $iColSrch & @CRLF)

;ConsoleWrite("$iColorSrch = " & $iColorSrch & @CRLF)

If $iColNew = "Default" Or $iColNew = "" Then $iColNew = "${1}00 "

If StringRegExp($iColSrch, "([][)(?#^{}\\:|,.])", 0) = 1 Then

$iColorNew = $iColNew

Else

If StringLeft($iColNew, 2) = "0x" Then $iColNew = StringTrimLeft($iColNew, 2)

$iColorNew = $iColNew ;BBGGRRAA format

EndIf

;ConsoleWrite("Setting $iColorNew = " & $iColorNew & @CRLF)

GUICtrlSetData($Label2, "Running", "")

GUICtrlSetColor($Label2, 0xFF0000)

$Timer = TimerInit()

$Reslt = _GDIPlus_BitmapLockBits($hBitmap1, 0, 0, $iGuiSizeX, $iGuiSizeY, BitOR($GDIP_ILMREAD, $GDIP_ILMWRITE), $GDIP_PXF32ARGB)

;Get the returned values of _GDIPlus_BitmapLockBits ()

$width = DllStructGetData($Reslt, "width")

$height = DllStructGetData($Reslt, "height")

$stride = DllStructGetData($Reslt, "stride")

$format = DllStructGetData($Reslt, "format")

$Scan0 = DllStructGetData($Reslt, "Scan0")

$v_BufferA = DllStructCreate("byte[" & $height * $width * 4 & "]", $Scan0)

$AllPixels = DllStructGetData($v_BufferA, 1)

;ConsoleWrite("$AllPixels, raw data, first 9 colours = " & StringRegExpReplace($AllPixels, "(.{98})(.*)", "\1") & @CRLF)

$sREResult1 = StringRegExpReplace(StringTrimLeft($AllPixels, 2), "(.{8})", "\1 ")

;ConsoleWrite("$sREResult1 first 9 colours = " & StringRegExpReplace($sREResult1, "(.{81})(.*)", "\1") & @CRLF)

;=====================================================================================

#cs

Local $search = "000000FF"; First

StringReplace($sREResult1, $search, $search)

Local $iNumOccor = @extended

Local $aResult = "0x" & $search & " No. of matches = " & $iNumOccor & @LF & @LF

Local $sResult

For $x = 1 To $iNumOccor

; With space added in $sREResult1, No. of characters per pixel is 9.

$sResult = (StringInStr($sREResult1, $search, 0, $x) - 1) / 9 ; Pixel position in string.

Local $iPosY = Int($sResult / $width) + 1 ; Y pos of pixel from string position.

Local $iPosX = ($sResult - (($iPosY - 1) * $width)) + 1; X Pos of pixel from same string position.

$aResult &= "posX = " & $iPosX & " posY = " & $iPosY & @LF

Next

MsgBox(0, "Found Pixels", $aResult)

#ce

;================================================================================

If $Range = 0 Then

If StringRegExp($iColorSrch, "([][)(?#^{}\\:|,.])", 0) = 0 Then ;and StringLen($iColorSrch) = 8

If StringLeft($iColorNew, 2) = "0x" Then $iColorNew = StringTrimLeft($iColorNew, 2)

Local $sResult = StringStripWS(StringRegExpReplace($sREResult1, "(" & StringTrimRight(StringTrimLeft($iColorSrch, 2), 2) & ")(.{2}) ", $iColorNew), 8)

;ConsoleWrite("Here " & "(" & StringTrimRight(StringTrimLeft($iColorSrch,2),2) & ")(.{2}) " & @CRLF & "$iColorNew " & $iColorNew & @CRLF)

Else

If StringLeft($iColorNew, 2) = "0x" Then $iColorNew = StringTrimLeft($iColorNew, 2)

If StringLeft($iColorSrch, 2) = "0x" Then $iColorSrch = StringTrimLeft($iColorSrch, 2)

Local $sResult = StringStripWS(StringRegExpReplace($sREResult1, $iColorSrch, $iColorNew), 8)

;ConsoleWrite("Here False regexp $Range = 0 " & $iColorSrch & " hex($iColorNew) " & $iColorNew & @CRLF)

EndIf

Else

$iRnge = Int(255 * $Range / 200)

$blue = "0x" & Hex(BitShift(BitAND(0xFF000000, $iColorSrch), 24), 2)

;ConsoleWrite("$blue = " & $blue & @CRLF )

$sBlueString = StringRERange($blue, $iRnge)

;ConsoleWrite("$sBlueString = " & $sBlueString & @CRLF & @CRLF)

$green = "0x" & Hex(BitShift(BitAND(0x00FF0000, $iColorSrch), 16), 2)

;ConsoleWrite("$green = " & $green & @CRLF )

$sGreenString = StringRERange($green, $iRnge)

;ConsoleWrite("$sGreenString = " & $sGreenString & @CRLF & @CRLF)

$red = "0x" & Hex(BitShift(BitAND(0x0000FF00, $iColorSrch), 8), 2)

;ConsoleWrite("$red = " & $red & @CRLF )

$sRedString = StringRERange($red, $iRnge)

;ConsoleWrite("$sRedString = " & $sRedString & @CRLF & @CRLF)

$sSearch = "(" & $sBlueString & $sGreenString & $sRedString & ")"

Local $sResult = StringStripWS(StringRegExpReplace($sREResult1, $sSearch & "FF ", $iColorNew), 8) ; "${1}00 "), 8)

EndIf

;ConsoleWrite("$iColorNew = " & $iColorNew & @CRLF)

;ConsoleWrite("$sREResult1 first 9 colours = " & StringRegExpReplace($sResult, "(.{81})(.*)", "\1") & @CRLF)

DllStructSetData($v_BufferA, 1, "0x" & $sResult)

_GDIPlus_BitmapUnlockBits($hBitmap1, $Reslt)

;ConsoleWrite("Process time = " & Round(TimerDiff($Timer) / 1000, 6) & " Secs" & @CRLF)

GUICtrlSetData($Label2, String(Round(TimerDiff($Timer) / 1000, 3)) & " Secs")

GUICtrlSetColor($Label2, 0x000000)

Return $hBitmap1

EndFunc ;==>ImageColorToTransparent

Func StringRERange($iColSrch, $iRnge)

Local $str = "(", $iColSrchMin, $iColSrchMax

$iColSrchMin = "0x" & Hex((Dec(Hex($iColSrch)) - $iRnge) * ((Dec(Hex($iColSrch)) - $iRnge) > 0), 2)

$iColSrchMax = "0x" & Hex((Dec(Hex($iColSrch)) + $iRnge) * ((Dec(Hex($iColSrch)) + $iRnge) < 255) + 255, 2)

;ConsoleWrite("$iColSrch = " & Hex($iColSrch) & " $iColSrchMin = " & Hex($iColSrchMin) & " $iColSrchMax = " & Hex($iColSrchMax) & @CRLF)

;ConsoleWrite("$iColSrch = " & Dec(Hex($iColSrch)) & " $iColSrchMin = " & Dec(Hex($iColSrchMin)) & " $iColSrchMax = " & Dec(Hex($iColSrchMax)) & @CRLF)

For $n = $iColSrchMin To $iColSrchMax

$str &= Hex($n, 2) & "|"

Next

$str = StringTrimRight($str, 1) & ")"

Return $str

EndFunc ;==>StringRERange

;The GetPixel method gets the color of a specified pixel in this bitmap.

Func GDIPlus_BitmapGetPixel($hBitmap, $iX, $iY)

Local $tArgb, $aRet

$tArgb = DllStructCreate("dword Argb")

$aRet = DllCall($ghGDIPDll, "int", "GdipBitmapGetPixel", "hwnd", $hBitmap, "int", $iX, "int", $iY, "ptr", DllStructGetPtr($tArgb))

Return "0x" & Hex(DllStructGetData($tArgb, "Argb"))

EndFunc ;==>GDIPlus_BitmapGetPixel

Func MY_PAINT($hWnd, $msg, $wParam, $lParam)

If $hWnd = $hGUI1 Then _GDIPlus_GraphicsDrawImageRect($hGraphic1, $OWin, 0, 0, $GuiSizeX, $GuiSizeY)

If $hWnd = $hGUI2 Then

If GUICtrlRead($Input[14]) > 0 Or GUICtrlRead($Input[15]) > 0 Then

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[8])), GUICtrlRead($Input[9]), GUICtrlRead($Input[10]), _

Execute(GUICtrlRead($Input[11])), Execute(GUICtrlRead($Input[12])))

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[13])), GUICtrlRead($Input[14]), GUICtrlRead($Input[15]), _

Execute(GUICtrlRead($Input[16])), Execute(GUICtrlRead($Input[17])))

Else

_GDIPlus_GraphicsDrawImageRect($hGraphic2, Execute(GUICtrlRead($Input[8])), GUICtrlRead($Input[9]), GUICtrlRead($Input[10]), _

Execute(GUICtrlRead($Input[11])), Execute(GUICtrlRead($Input[12])))

EndIf

EndIf

Return $GUI_RUNDEFMSG

EndFunc ;==>MY_PAINT

Func Color_SetHSL($iHue, $Saturation = 150, $Brightness = 200);160)

If IsArray($iHue) Then

$aInput = $iHue

Else

Local $aInput[3] = [$iHue, $Saturation, $Brightness]

EndIf

Local $aiRGB = _ColorConvertHSLtoRGB($aInput)

Return "0x" & Hex(Round($aiRGB[0]), 2) & Hex(Round($aiRGB[1]), 2) & Hex(Round($aiRGB[2]), 2)

EndFunc ;==>Color_SetHSL

; Copied from ...\Include\Misc.au3 File

Func IsPressed($sHexKey)

Local $a_R = DllCall('user32.dll', "int", "GetAsyncKeyState", "int", '0x' & $sHexKey)

If Not @error And BitAND($a_R[0], 0x8000) = 0x8000 Then Return 1

Return 0

EndFunc ;==>IsPressed

Func GetPixel($handle, $x, $y)

Local $dc, $icolor, $iRet

$dc = DllCall("user32.dll", "int", "GetDC", "hwnd", $handle)

$icolor = DllCall("gdi32.dll", "long", "GetPixel", "hwnd", $dc[0], "int", $x, "int", $y)

DllCall("user32.dll", "int", "ReleaseDC", "hwnd", 0, "int", $dc[0])

; Converts RGB to BGR colour and visa-versa

$iRet = $icolor[0] ; BitAND(BitShift(String(Binary($iColor[0])), 8), 0xFFFFFF) ; Converts RGB to BGR colour and visa-versa

Return "0x" & Hex($iRet, 6)

EndFunc ;==>GetPixel

Func _WinAPI_StretchBlt($hDestDC, $iXDest, $iYDest, $iWidth, $iHeight, $hSrcDC, $iXSrc, $iYSrc, $iWidthSrc, $iHeightSrc, $iROP)

Local $aResult = DllCall("GDI32.dll", "int", "StretchBlt", "hwnd", $hDestDC, "int", $iXDest, "int", $iYDest, "int", $iWidth, "int", $iHeight, _

"hwnd", $hSrcDC, "int", $iXSrc, "int", $iYSrc, "int", $iWidthSrc, "int", $iHeightSrc, "int", $iROP)

If @error Then Return SetError(@error, 0, False)

Return $aResult[0] <> 0

EndFunc ;==>_WinAPI_StretchBlt

; This next script is for working out the regular expression.

Local $v_ValueA = "0xA56E3AFFA56E3AFFA56E3AFFA56E3AFFA56E3A00A56E3A00C8D0D4FFC8D0D4FFC8D0D4FFC8D0D400C8D0D4FF"

Local $sREResult1 = StringRegExpReplace(StringTrimLeft($v_ValueA, 2), "(.{8})", "\1 ")

;$sREResult = StringRegExpReplace($sREResult1, "([0-9B-D]{6})(FF)", "${1}00"); Get a range of colours to make transparent
;$sREResult = StringRegExpReplace($sREResult1, "(A56E3AFF|C8D0D4FF)", "000000FF"); Get specficate colour to change
Local $sResult  = StringRegExpReplace($sREResult1, "([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})(FF)", "${3}${2}${1}${4}"); Swap blue & red chanells.

MsgBox(0,"Result", $sResult)