#include <Array.au3>
#include <GuiConstantsEx.au3>
#include <GDIPlus.au3>
#include <Misc.au3>
#include <ScreenCapture.au3>
; http://www.autoitscript.com/forum/index.php?s=&showtopic=91755&view=findpost&p=663576
Opt('MustDeclareVars', 1)

Global $width, $height, $hGUI1, $hGUI2, $hImage, $hImage2, $hGraphic1, $hGraphic2, $iX, $iY, $sImageIn

_Main()
;Run('C:\Program Files\GIMP 2\bin\gimp-2.8.exe "F:\Program Files\Autoio\Examples\Uploads\ColMod.png"')

Func _Main()
    ;$sImageIn = "C:\Windows\Globalization\MCT\MCT-AU\Wallpaper\AU-wp2.jpg"
    ;$sImageIn = "C:\Users\Mal\Documents\Singer29K58BootPatcher6.png"
    ;or
    ; Capture top left corner of the screen
    ;$sImageIn = "GDIPlus_Image.png"
    ;_ScreenCapture_Capture($sImageIn, 0, 0, 400, 300)
    ;Or
    $sImageIn = FileOpenDialog("First image", "", "All images (*.jpg;*.png;*.gif;*.bmp;)")
    ;If $sImageIn = "" Then Exit
    ;ConsoleWrite($sImageIn & @LF)
    ;Or
    ;InetGet("http://img11.nnm.ru/a/1/5/b/0/1dba2209d5a133d9e84431a5587.jpg","FireWorksSydney.jpg")
    ;$sImageIn = "FireWorksSydney.jpg"

    ; Create a GUI for the original image
    $hGUI1 = GUICreate("Original", 400, 300, 0, 0)
    GUISetState()

    ; Create a GUI for the zoomed image
    $hGUI2 = GUICreate("Ctrl + Left click to save image", 400, 300, 0, 400)
    GUISetState()
    GUIRegisterMsg(0xF, "MY_PAINT"); Register PAINT-Event 0x000F = $WM_PAINT (WindowsConstants.au3)
    ; Initialize GDI+ library and load image
    _GDIPlus_Startup()
    ;$hImage = _GDIPlus_ImageLoadFromFile(@MyDocumentsDir & "\GDIPlus_Image.png")
    $hImage = _GDIPlus_ImageLoadFromFile($sImageIn)
    $iX = _GDIPlus_ImageGetWidth($hImage)
    $iY = _GDIPlus_ImageGetHeight($hImage)
    _GDIPlus_BitmapSetPixel($hImage, 110, 80, 0xFF000000)
    ; Draw original image
    $hGraphic1 = _GDIPlus_GraphicsCreateFromHWND($hGUI1)
    ;_GDIPlus_GraphicsDrawImage($hGraphic1, $hImage, 0, 0)
    _GDIPlus_GraphicsDrawImageRectRect($hGraphic1, $hImage, 0, 0, $iX, $iY, 0, 0, 400, 300)


    ; ====== Examples calling _ImageColorRegExpReplace() =========================
    ; Note colour format hex 0xBBGGRRAA - Blue, Green, Red, Alpha (transparency)

    ;$hImage2 = _ImageColorRegExpReplace($hImage, "FFFFFFFF", "000000FF"); Change white to black.
    $hImage2 = _ImageColorRegExpReplace($hImage, "(?i)([E-F][0-9A-F]){3}FF" , "000000FF" ); Change almost white to black.
    ;$hImage2 = _ImageColorRegExpReplace($hImage, "(000000FF)" , "FFFFFFFF" ); Change black to white
    ;$hImage2 = _ImageColorRegExpReplace($hImage, "(FFFFFFFF)" , "FFFFFF00" ); Change white to transparent
    ;$hImage2 = _ImageColorRegExpReplace($hImage, "(([A-F][0-9A-F]){3}FF)" , "000000FF" ); Change near to white to transparent
    ;$hImage2 = _ImageColorRegExpReplace($hImage, "(FF0000FF|(0000[A-F]{2}FF)|FFFFFFFF)", "000000FF"); Change blue, off red, white to black

    ;Swap red and blue channels on half the image. Image is 400x300 = 120,000 pixels. Number of pixels to replace is 60,000.
    ;$hImage2 = _ImageColorRegExpReplace($hImage, "(?i)([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})(FF)", "${2}${3}${1}${4}")

    ; Image to black and white
    ;$hImage2 = _ImageColorRegExpReplace($hImage, "(?i)([9A-F][0-9A-F]{5}FF)" , "FFFFFFFF" ); Change near to white to white
    ;$hImage2 = _ImageColorRegExpReplace($hImage2, "(?i)([0-8][0-9A-F]{5}FF)" ,  "000000FF" ); Change near black  to black
    ;$hImage2 = _ImageColorRegExpReplace($hImage, "(?i)(([0-9A-D][0-9A-F]){3}FF)", "FFFFFF00"); Change near to white to white
    ;$hImage2 = _ImageColorRegExpReplace($hImage, _NotHexColorREPattern("FFFFFFFF", 0xC9), "FFFFFF00")
    ;$hImage2 = _ImageColorRegExpReplace($hImage, _ShadeVariationREPattern("606060FF", 0x9E), "FFFFFF00")
    ;or
    ;$hImage2 = _ImageColorRegExpReplace($hImage,  "(?i)([0-9A-F]{2}[9A-F][0-9A-F]{3}FF)" , "FFFFFFFF" ); Change near to white to white
    ;$hImage2 = _ImageColorRegExpReplace($hImage2, "(?i)([0-9A-F]{2}[0-8][0-9A-F]{3}FF)" ,  "000000FF" ); Change near black  to black

    ;$hImage2 = _ImageColorRegExpReplace($hImage, "(FFFFFFFF)", "000000FF"); Change near to white to black
    ;$hImage2 = _ImageColorRegExpReplace($hImage, _NotHexColorREPattern("808080FF", 0x77), "FFFFFF00"); Change near to white to white

    ;$hImage2 = _ImageColorRegExpReplace($hImage, "(.{8}) (.{8}) (.{8}) ", "\1 00000000 00000000 "); Change near to white to white
    ;$hImage2 = _ImageColorRegExpReplace($hImage, _ShadeVariationREPattern("0000FFFF", 0x10, False), "000000FF"); Change near to white to white
    ;$hImage2 = _ImageColorRegExpReplace($hImage, _ShadeVariationREPattern("606060FF", 0x90, False), "FFFFFF00"); Change near to white to white
    ;$hImage2 = _ImageColorRegExpReplace($hImage, "808080FF", "FFFFFF00");

    ;_ImagePixelPos($hImage, "0000FFFF")
    ;==============================================================================================



    ; Draw RegExpReplace image
    $hGraphic2 = _GDIPlus_GraphicsCreateFromHWND($hGUI2)
    ;_GDIPlus_GraphicsDrawImage($hGraphic2, $hImage2, 0, 0)
    _GDIPlus_GraphicsDrawImageRectRect($hGraphic2, $hImage2, 0, 0, $iX, $iY, 0, 0, 400, 300)
    ;$hImage3 = _GDIPlus_BitmapCreateFromHBITMAP ($hImage2)
    ;ConsoleWrite("$hImage2   " & $hImage2 & @CRLF)


    ; Clean up screen shot file
    FileDelete(@MyDocumentsDir & "\GDIPlus_Image.jpg")

    ; Loop until user exits
    Do
        If _IsPressed("01") And _IsPressed("11") Then ;Left click + Ctrl key to save image
            Do
            Until Not _IsPressed("01")
            Local $PathFile = FileSaveDialog("Choose a name.", @ScriptDir & "\", "Images (*.bmp;*.jpg;*.png;*.gif)|All files (*.*)", 16, "ColourModify.png")
            If Not @error Then
                _GDIPlus_ImageSaveToFile($hImage2, $PathFile)
                ;ShellExecute(@ScriptDir & "\ColMod.png")
            EndIf
        EndIf
        Sleep(10)
    Until GUIGetMsg() = $GUI_EVENT_CLOSE

    ; Release resources
    _GDIPlus_GraphicsDispose($hGraphic1)
    _GDIPlus_GraphicsDispose($hGraphic2)
    _GDIPlus_ImageDispose($hImage)
    _GDIPlus_ImageDispose($hImage2)
    _GDIPlus_Shutdown()
EndFunc   ;==>_Main

Func _ImagePixelPos($hImage, $iColSrch, $iCount = 0)
    Local $hTimer = TimerInit()
    Local $Reslt, $stride, $format, $Scan0, $iIW, $iIH, $hBitmap1
    Local $v_BufferA, $AllPixels, $sREResult1, $sResult, $iNum,$iNum2, $i, $sRes, $y

    $iIW = _GDIPlus_ImageGetWidth($hImage)
    $iIH = _GDIPlus_ImageGetHeight($hImage)
    ;ConsoleWrite($iIW & "  " & $iIH & @LF)
    $hBitmap1 = _GDIPlus_BitmapCloneArea($hImage, 0, 0, $iIW, $iIH, $GDIP_PXF32ARGB)

    ; Locks a portion of a bitmap for reading or writing
    $Reslt = _GDIPlus_BitmapLockBits($hBitmap1, 0, 0, $iIW, $iIH, BitOR($GDIP_ILMREAD, $GDIP_ILMWRITE), $GDIP_PXF32ARGB)
    ;Get the returned values of _GDIPlus_BitmapLockBits ()
    $width = DllStructGetData($Reslt, "width")
    $height = DllStructGetData($Reslt, "height")
    $stride = DllStructGetData($Reslt, "stride")
    $format = DllStructGetData($Reslt, "format")
    $Scan0 = DllStructGetData($Reslt, "Scan0")
    $v_BufferA = DllStructCreate("byte[" & $height * $width * 4 & "]", $Scan0) ; Create DLL structure for all pixels
    $AllPixels = DllStructGetData($v_BufferA, 1)
    ;ConsoleWrite("$AllPixels, raw data, first 9 colours = " & StringRegExpReplace($AllPixels, "(.{98})(.*)", "\1") & @CRLF)

    ; Searches on this string - $sREResult1 whch has the prefix "0x"  removed and a space put between pixels 8 characters long.
    $sREResult1 = StringRegExpReplace(StringTrimLeft($AllPixels, 2), "(.{8})", "\1 ")
    ;ConsoleWrite("$sREResult1 first 9 colours = " & StringRegExpReplace($sREResult1, "(.{81})(.*)", "\1") & @CRLF)

    If StringInStr($sREResult1, $iColSrch) > 0 Then
        StringRegExpReplace($sREResult1, "(" & $iColSrch & ")", "\1")
        Local $iTotalPixelsFound = @extended
        $sRes &= $iTotalPixelsFound & " matches found between" & @CRLF
        $iNum = StringInStr($sREResult1, $iColSrch, 0, 1)
            $y = Int(($iNum) / (9 * $width))
            $sRes &= "(" & Int(((($iNum) / (9 * $width)) - $y) * $width) & "," & $y & ")" & @LF
            $iNum2 = StringInStr($sREResult1, $iColSrch, 0, -1)
            $y = Int(($iNum2) / (9 * $width))
            $sRes &= " and " & @CRLF &  "(" & Ceiling(((($iNum2) / (9 * $width)) - $y) * $width) & "," & $y & ")"  &@LF
        ;ConsoleWrite($iTotalPixelsFound & @LF)
        ;Local $aPixs[$iTotalPixelsFound +1][2]
        ;$aPixs[0][0] = $iTotalPixelsFound
        ;For $i = 1 To $iTotalPixelsFound step 5
        ;   $iNum = StringInStr($sREResult1, $iColSrch, 0, $i) + 1
        ;   $y = Int(($iNum) / (9 * $width))
        ;   $sRes &= Int(($iNum) / (9 * $width)) & "," & Int(((($iNum) / (9 * $width)) - $y) * $width) & @LF
        ;   $aPixs[$i][1] = Int(($iNum) / (9 * $width))
        ;   $aPixs[$i][0] = Int(((($iNum) / (9 * $width)) - $aPixs[$i][1]) * $width)
        ;   ConsoleWrite($i & " " & $aPixs[$i][0] & " " & $aPixs[$i][1] & " " & @LF)
        ;Next
    EndIf

    _GDIPlus_BitmapUnlockBits($hBitmap1, $Reslt) ; releases the locked region
    ConsoleWrite("Time =" & TimerDiff($hTimer) & @LF)
    ConsoleWrite($sRes & @LF)
    ;_ArrayDisplay($aPixs)
    Return $hBitmap1
EndFunc   ;==>_ImagePixelPos

; ========= _ImageColorRegExpReplace($hImage, $iColSrch, $iColNew,$iCount = 0) =====================
;Paramerers:-
; $hImage   - Handle to a Bitmap object
; $iColSrch - A regular expression pattern to compare the colours to in 0xBBGGRRAA hex colour format.
; $iColNew  - The colour which will replace the regular expression matching colour.Also in 0xBBGGRRAA hex colour format.
; $iCount - [optional] The number of times to execute the replacement in the image. The default is 0. Use 0 for global replacement.
; Note :- Colour format in hex 0xBBGGRRAA
;
Func _ImageColorRegExpReplace($hImage, $iColSrch, $iColNew, $iCount = 0)
    Local $Reslt, $stride, $format, $Scan0, $iIW, $iIH, $hBitmap1
    Local $v_BufferA, $AllPixels, $sREResult1, $sResult

    $iIW = _GDIPlus_ImageGetWidth($hImage)
    $iIH = _GDIPlus_ImageGetHeight($hImage)
    ;ConsoleWrite($iIW & "  " & $iIH & @LF)
    $hBitmap1 = _GDIPlus_BitmapCloneArea($hImage, 0, 0, $iIW, $iIH, $GDIP_PXF32ARGB)

    ; Locks a portion of a bitmap for reading or writing
    $Reslt = _GDIPlus_BitmapLockBits($hBitmap1, 0, 0, $iIW, $iIH, BitOR($GDIP_ILMREAD, $GDIP_ILMWRITE), $GDIP_PXF32ARGB)

    ;Get the returned values of _GDIPlus_BitmapLockBits ()
    $width = DllStructGetData($Reslt, "width")
    $height = DllStructGetData($Reslt, "height")
    $stride = DllStructGetData($Reslt, "stride")
    $format = DllStructGetData($Reslt, "format")
    $Scan0 = DllStructGetData($Reslt, "Scan0")

    $v_BufferA = DllStructCreate("byte[" & $height * $width * 4 & "]", $Scan0) ; Create DLL structure for all pixels
    $AllPixels = DllStructGetData($v_BufferA, 1)
    ;ConsoleWrite("$AllPixels, raw data, first 9 colours = " & StringRegExpReplace($AllPixels, "(.{98})(.*)", "\1") & @CRLF)

    ; Searches on this string - $sREResult1 whch has the prefix "0x"  removed and a space put between pixels 8 characters long.
    $sREResult1 = StringRegExpReplace(StringTrimLeft($AllPixels, 2), "(.{8})", "\1 ")
    ;ConsoleWrite("$sREResult1 first 9 colours = " & StringRegExpReplace($sREResult1, "(.{81})(.*)", "\1") & @CRLF)

    If StringInStr($iColNew, "0x") > 0 Then $iColNew = StringReplace($iColNew, "0x", ""); Remove "0x" not needed

    ; StringRegExpReplace performed and white spaces removed
    $sResult = StringStripWS(StringRegExpReplace($sREResult1, $iColSrch, $iColNew, $iCount), 8)

    ; Replace "0x" prefix and set modified data back to DLL structure, $v_BufferA
    DllStructSetData($v_BufferA, 1, "0x" & $sResult)
    _GDIPlus_BitmapUnlockBits($hBitmap1, $Reslt) ; releases the locked region

    Return $hBitmap1
EndFunc   ;==>_ImageColorRegExpReplace

Func MY_PAINT($hWnd, $msg, $wParam, $lParam)
    If $hWnd = $hGUI1 Then _GDIPlus_GraphicsDrawImageRectRect($hGraphic1, $hImage, 0, 0, $iX, $iY, 0, 0, 400, 300) ; _GDIPlus_GraphicsDrawImageRect($hGraphic1, $hImage, 0, 0, $width, $height)

    If $hWnd = $hGUI2 Then _GDIPlus_GraphicsDrawImageRectRect($hGraphic2, $hImage2, 0, 0, $iX, $iY, 0, 0, 400, 300) ; _GDIPlus_GraphicsDrawImageRect($hGraphic2, $hImage2, 0, 0, $width, $height)

    Return $GUI_RUNDEFMSG
EndFunc   ;==>MY_PAINT

;======================== _ShadeVariationREPattern ===========================
; Description - Checks if a 24bit color matches a specified color plus or minus a shade varation.
; Parameters
; $iColor   - A 'RGB' or 'ARGB' color to test.
; $ShadeVariation - An integer added to and substracted from each color channel of the color, $iColPlusShade.
;   $ARGB           - If $iColor Format is in 0xAARRGGBB hex format then $ARGB = True is default.
;                    If false then $iColor Format is in 0xBBGGRRAA hex format.
; Returns 1 (matched) or 0 (no match)
;
Func _ShadeVariationREPattern($iColor, $ShadeVariation, $ARGB = True)
    Local $Pattern, $iColSrchMin, $iColSrchMax
    If $ARGB Then $iColor = "0x" & StringRegExpReplace(Hex($iColor, 8), "(..)(..)(..)(..)", "\4\3\2\1")
    ;ConsoleWrite(hex($iColor, 8) & @CRLF)
    Local $aColor = StringRegExp(Hex("0x" & $iColor, 8), "(.{2})", 3)
    ;_ArrayDisplay($aColor)

    For $i = 0 To UBound($aColor) - 2
        $Pattern &= "("
        $iColSrchMin = Hex(Int(((("0x" & $aColor[$i]) - $ShadeVariation) > 0) ? (("0x" & $aColor[$i]) - $ShadeVariation) : 0), 2)
        $iColSrchMax = Hex(Int(((("0x" & $aColor[$i]) + $ShadeVariation) < 256) ? (("0x" & $aColor[$i]) + $ShadeVariation) : 255), 2)
        ;$iColSrchMax = "0x" & Hex((Dec(Hex("0x" & $aColor[$i], 2)) + $ShadeVariation + 1) * ((Dec(Hex("0x" & $aColor[$i], 2)) + $ShadeVariation + 1) < 255) + 255, 2)
        ConsoleWrite($iColSrchMin & " to " & $iColSrchMax & @CRLF)
        For $n = "0x" & $iColSrchMin To "0x" &$iColSrchMax
            $Pattern &= Hex($n, 2) & "|"
        Next
        $Pattern = StringTrimRight($Pattern, 1) & ")"
    Next
    ;ConsoleWrite($Pattern & "(FF)" & @LF)
    Return $Pattern & "(FF)"
EndFunc   ;==>_ShadeVariationREPattern

Func _NotHexColorREPattern($In, $iVariation = 0x00)
    Local $aPat[16][16] = [ _ ;       2          3             4           5             6           7            8         9          A          B             C          D          E          T
            ["1-9A-F", "2-9A-F" , "3-9A-F"  , "4-9A-F"   , "5-9A-F"   , "6-9A-F"   , "7-9A-F"   , "8-9A-F"   , "9A-F"   , "A-F"    , "B-F"     , "C-F"     , "D-F"     , "EF"      , "F"      , "."], _      ;0
            ["2-9A-F", "02-9A-F", "03-9A-F" , "04-9A-F"  , "05-9A-F"  , "06-9A-F"  , "07-9A-F"  , "08-9A-F"  , "09A-F"  , "0A-F"   , "0B-F"    , "0B-F"    , "0C-F"    , "0D-F"    , "0EF"    , "0"], _      ;1
            ["3-9A-F", "03-9A-F", "013-9A-F", "014-9A-F" , "015-9A-F" , "016-9A-F" , "017-9A-F" , "018-9A-F" , "019A-F" , "01A-F"  , "01B-F"   , "01C-F"   , "01D-F"   , "01EF"    , "01F"    , "01"], _     ;2
            ["4-9A-F", "04-9A-F", "014-9A-F", "0-24-9A-F", "0-25-9A-F", "0-26-9A-F", "0-27-9A-F", "0-28-9A-F", "0-29A-F", "0-2A-F" , "0-2B-F"  , "0-2C-F"  , "0-2D-F"  , "0-2EF"   , "0-2F"   , "0-2"], _    ;3
            ["5-9A-F", "05-9A-F", "015-9A-F", "0-25-9A-F", "0-35-9A-F", "0-36-9A-F", "0-37-9A-F", "0-38-9A-F", "0-39A-F", "0-3A-F" , "0-3B-F"  , "0-3C-F"  , "0-3D-F"  , "0-3EF"   , "0-3F"   , "0-3"], _    ;4
            ["6-9A-F", "06-9A-F", "016-9A-F", "0-26-9A-F", "0-36-9A-F", "0-46-9A-F", "0-47-9A-F", "0-48-9A-F", "0-49A-F", "0-4A-F" , "0-4B-F"  , "0-4C-F"  , "0-4D-F"  , "0-4FF"   , "0-4F"   , "0-4"], _    ;5
            ["7-9A-F", "07-9A-F", "017-9A-F", "0-27-9A-F", "0-37-9A-F", "0-47-9A-F", "0-57-9A-F", "0-58-9A-F", "0-59A-F", "0-5A-F" , "0-5B-F"  , "0-5C-F"  , "0-5D-F"  , "0-5EF"   , "0-5F"   , "0-5"], _    ;6
            ["89A-F" , "089A-F" , "0189A-F" , "0-289A-F" , "0-389A-F" , "0-489A-F" , "0-589A-F" , "0-689A-F" , "0-69A-F", "0-6A-F" , "0-6B-F"  , "0-6C-F"  , "0-6D-F"  , "0-6EF"   , "0-6F"   , "0-6"], _    ;7
            ["9A-F"  , "09A-F"  , "019A-F"  , "0-29A-F"  , "0-39A-F"  , "0-49A-F"  , "0-59A-F"  , "0-69A-F"  , "0-79A-F", "0-7A-F" , "0-7B-F"  , "0-7C-F"  , "0-7D-F"  , "0-7EF"   , "0-7F"   , "0-79"], _   ;8
            ["A-F"   , "0A-F"   , "01A-F"   , "0-2A-F"   , "0-3A-F"   , "0-4A-F"   , "0-5A-F"   , "0-6A-F"   , "0-7A-F" , "0-8A-F" , "0-8B-F"  , "0-8C-F"  , "0-8D-F"  , "0-8EF"   , "0-8F"   , "0-8"], _    ;9
            ["B-F"   , "0B-F"   , "01B-F"   , "0-2B-F"   , "0-3B-F"   , "0-4B-F"   , "0-5B-F"   , "0-6B-F"   , "0-7B-F" , "0-8B-F" , "0-9B-F"  , "0-9C-F"  , "0-9D-F"  , "0-9EF"   , "0-9F"   , "0-9"], _    ;A
            ["C-F"   , "0C-F"   , "01C-F"   , "0-2C-F"   , "0-3C-F"   , "0-4AC-F"  , "0-5C-F"   , "0-6C-F"   , "0-7C-F" , "0-8C-F" , "0-9C-F"  , "0-9AC-F" , "0-9AD-F" , "0-9AEF"  , "0-9AF"  , "0-9AC"], _  ;B
            ["D-F"   , "0D-F"   , "01D-F"   , "0-2D-F"   , "0-3D-F"   , "0-4D-F"   , "0-5D-F"   , "0-6D-F"   , "0-7D-F" , "0-8D-F" , "0-9D-F"  , "0-9AD-F" , "0-9ABD-F", "0-9ABEF" , "0-9ABF" , "0-9AB"], _  ;C
            ["EF"    , "0EF"    , "01EF"    , "0-2EF"    , "0-3EF"    , "0-4EF"    , "0-5EF"    , "0-6EF"    , "0-7EF"  , "0-8EF"  , "0-9EF"   , "0-9AEF"  , "0-9ABEF" , "0-9A-CEF", "0-9A-CF", "0-9A-C"], _ ;D
            ["F"     , "0F"     , "01F"     , "0-2F"     , "0-3F"     , "0-4F"     , "0-5F"     , "0-6F"     , "0-7F"   , "0-8F"   , "0-9F"    , "0-9AF"   , "0-9ABF"  , "0-9A-CF" , "0-9A-DF", "0-9A-D"], _ ;E
            ["."     , "0"      , "01"      , "0-2"      , "0-3"      , "0-4"      , "0-5"      , "0-6"      , "0-7"    , "0-8"    , "0-9"     , "0-9A"    , "0-9AB"   , "0-9A-C"  , "0-9A-D" , "0-9A-E"]]   ;F

    Local $sRet, $aArr, $iLower, $iUpper, $aVari[8][2]
    If IsNumber($In) Then $In = Hex($In, 8)
    If StringLeft($In, 2) == "0x" Then $In = StringTrimLeft($In, 2)
    $aArr = StringRegExp($In, "(..)", 3)
    For $i = 0 To 2
        $iLower = Hex(Int(((("0x" & $aArr[$i]) - $iVariation) > 0) ? (("0x" & $aArr[$i]) - $iVariation) : 0), 2)
        $iUpper = Hex(Int(((("0x" & $aArr[$i]) + $iVariation) < 256) ? (("0x" & $aArr[$i]) + $iVariation) : 255), 2)
        $aVari[$i * 2][0] = "0x" & StringLeft($iLower, 1)
        $aVari[$i * 2][1] = "0x" & StringLeft($iUpper, 1)
        $aVari[$i * 2 + 1][0] = "0x" & StringRight($iLower, 1)
        $aVari[$i * 2 + 1][1] = "0x" & StringRight($iUpper, 1)
    Next
    ;Alpha channel
    $aVari[6][0] = "0xF"
    $aVari[6][1] = "0xF"
    $aVari[7][0] = "0xF"
    $aVari[7][1] = "0xF"
    For $i = 0 To UBound($aVari) - 1
        $sRet &= "([0-9A-F]{" & $i & "}[" & $aPat[$aVari[$i][0]][$aVari[$i][1]] & "][0-9A-F]{" & (7 - $i) & "})|"
    Next
    ;if StringInStr(StringRegExpReplace(StringTrimRight($sRet, 1), "(\Q[0-9A-F]{0}\E)|(\Q{1}\E)", ""),"[]") Then
    ;   MsgBox(0,"Error", "
    ConsoleWrite(StringRegExpReplace(StringTrimRight($sRet, 1), "(\Q[0-9A-F]{0}\E)|(\Q{1}\E)", "") & @LF)
    ;_ArrayDisplay($aVari)
    Return StringRegExpReplace(StringTrimRight($sRet, 1), "(\Q[0-9A-F]{0}\E)|(\Q{1}\E)", "") ; |(\[\])
    ;Return StringTrimRight($sRet, 1)
EndFunc   ;==>_NotHexColorREPattern