#include <Constants.au3>
#include <WinAPIError.au3>
#include <WinAPI.au3>

_Main ()

Func _Main ()
Local $ctrl_handle

  Sleep(5000)
  Local $hWnd = ControlGetHandle("LDPlayer-1-0(64)","","subWin")

  Local $tPoint = DllStructCreate($tagPOINT)
  DllStructSetData($tPoint, "X", 354)
  DllStructSetData($tPoint, "Y", 278)

  _WinAPI_ScreenToClient ($hWnd, $tPoint)

;  MsgBox (0,"Test",DllStructgetData($tPoint, "X") & "/" & DllStructGetData($tPoint, "Y"))

  Local $thWnd = $hWnd


  _MouseClickPlus($thWnd, "left", 317, 281, 1)

  $tPoint = 0

EndFunc

Func _MouseClickPlus($hWnd, $sButton = 'left', $vX = '', $vY = '', $iClicks = 1)
    Local $MK_LBUTTON = 0x0001
    Local $WM_LBUTTONDOWN = 0x0201
    Local $WM_LBUTTONUP = 0x0202

    Local $MK_RBUTTON = 0x0002
    Local $WM_RBUTTONDOWN = 0x0204
    Local $WM_RBUTTONUP = 0x0205

    Local $WM_MOUSEMOVE = 0x0200

    If $sButton = 'left' Then
        $Button = $MK_LBUTTON
        $ButtonDown = $WM_LBUTTONDOWN
        $ButtonUp = $WM_LBUTTONUP
    ElseIf $sButton = 'right' Then
        $Button = $MK_RBUTTON
        $ButtonDown = $WM_RBUTTONDOWN
        $ButtonUp = $WM_RBUTTONUP
    EndIf

    If $vX = "" Or $vY = "" Then
        $MouseCoord = MouseGetPos()
        $vX = $MouseCoord[0]
        $vY = $MouseCoord[1]
    EndIf

    Local $stPoint = _MakeLong($vX, $vY)

    Local $i = 0
    For $i = 1 To $iClicks
        _PostMessage($hWnd, $WM_MOUSEMOVE, 0, $stPoint)
        _PostMessage($hWnd, $ButtonDown, $Button, $stPoint)
        _PostMessage($hWnd, $ButtonUp, $Button, $stPoint)
    Next
EndFunc

Func _MakeLong($LoWord,$HiWord)
  Return BitOR($HiWord * 0x10000, BitAND($LoWord, 0xFFFF))
EndFunc

Func _PostMessage($hWnd, $iMsg, $iwParam, $ilParam)
  Local $aResult, $err
  $aResult = DllCall("User32.dll", "bool", "PostMessageA", "hwnd", $hWnd, "int", $iMsg, "int", $iwParam, "int", $ilParam)
  $err = _WinAPI_GetLastError ()
  if $err or not $aResult[0] then
    MsgBox (0,"Error","Access denied in post message with error " & $err)
    Exit
  endif
  Return $aResult[0]
EndFunc