; version fix _VirtualQueryEx 32bit 64bit
#include-once
#include "Constants.au3"
; KryMemory64bit

; #INDEX# =======================================================================================================================
; Title .........: KryMemory
; AutoIt Version : 3.3.8.1
; Language ......: English
; Description ...: Functions for modifying and querying process memory.
; Author(s) .....: KryziK (John Fedorchak) <john.fedorchak@gmail.com>
; Dll(s) ........: Kernel32.dll
; ===============================================================================================================================

; #CURRENT# =====================================================================================================================
; _Process_Open($sProcessName, $iDesiredAccess = $PROCESS_ALL_ACCESS, $fInheritAccess = False)
; _Process_Close($ahHandle)
; _Process_ReadMemory($ahHandle, $ivAddress, $sType = "dword")
; _Process_ReadMemoryPointer($ahHandle, $ivAddress, $aiOffsets, $sType = "dword")
; _Process_WriteMemory($ahHandle, $ivAddress, $vData, $sType = "dword")
; _Process_WriteMemoryPointer($ahHandle, $ivAddress, $aiOffsets, $vData, $sType = "dword")
; _Process_GetBaseAddress($ahHandle)
; _Process_GetParent($ahHandle)
; _Process_GetModules($ahHandle)
;
; _Address_CalculateStatic($ahHandle, $sModuleName, $ivOffset)
; _Address_CalculatePointer($ahHandle, $ivAddress, $aiOffsets)
;
; _Module_GetBaseAddress($ahHandle, $sModuleName)
; ===============================================================================================================================

; #CONSTANTS# ===================================================================================================================
; CreateToolhelp32Snapshot
Global Const $TH32CS_SNAPPROCESS = 0x00000002
Global Const $TH32CS_SNAPMODULE = 0x00000008
Global Const $TH32CS_SNAPMODULE32 = 0x00000010
; ===============================================================================================================================

; #FUNCTION# ====================================================================================================================
; Name ..........: _Process_Open
; Description ...: Opens an existing local process object.
; Syntax ........: _Process_Open($sProcessName[, $iDesiredAccess = $PROCESS_ALL_ACCESS[, $fInheritAccess = False]])
; Parameters ....: $sProcessName        - A string value.
;                  $iDesiredAccess      - [optional] An integer value. Default is $PROCESS_ALL_ACCESS.
;											The access to the process object.
;											This access right is checked against the security descriptor for the process.
;											This parameter can be one or more of the process access rights.
;                  $fInheritAccess      - [optional] A boolean value. Default is False.
;											If this value is TRUE, processes created by this process will inherit the handle.
;											Otherwise, the processes do not inherit this handle.
; Return values .: $ahHandle			- An array of values, or FALSE if an error occurred.
;											$ahHandle[0] = Open handle to kernel32.dll.
;											$ahHandle[1] = Open handle to the specified process.
;											$ahHandle[2] = The identifier of the specified open process.
;				   @error -		0 = No error occurred.
;								1 = The specified process doesn't exist.
;								2 = A handle to kernel32.dll could not be opened.
;								3 = A handle to the specified process could not be opened.
;									@extended = @error of DllCall()
; Author ........: KryziK
; Modified ......: 1/12/2013
; Remarks .......:
; Related .......:
; Link ..........: http://msdn.microsoft.com/en-us/library/windows/desktop/ms684320.aspx
; Example .......: _Process_Open("KryziK.exe")
; ===============================================================================================================================
Func _Process_Open($sProcessName, $iDesiredAccess = $PROCESS_ALL_ACCESS, $fInheritAccess = False)
	Local $iPID = ProcessExists($sProcessName)

	If Not $iPID Then
		SetError(1, 0, False)
		;Return False
	EndIf

	Local $ahHandle[3] = [DllOpen("kernel32.dll"), 0, $iPID]

	If ($ahHandle[0] = -1) Then
		SetError(2, 0, False)
		;Return False
	EndIf

	Local $ahCall = DllCall($ahHandle[0], "handle", "OpenProcess", _
			"dword", $iDesiredAccess, _
			"bool", $fInheritAccess, _
			"dword", $iPID)

	If @error Then
		DllClose($ahHandle[0])
		SetError(3, @error, False)
		;Return False
	EndIf

	$ahHandle[1] = $ahCall[0]

	Return $ahHandle
EndFunc   ;==>_Process_Open

; #FUNCTION# ====================================================================================================================
; Name ..........: _Process_Close
; Description ...: Closes all handles associated with an array returned by _Process_Open.
; Syntax ........: _Process_Close($ahHandle)
; Parameters ....: $ahHandle            - An array of handles.
; Return values .: A boolean value. TRUE if CloseHandle succeeded in closing the open process handle, otherwise FALSE.
;				   @error -		0 = No error occurred.
;								1 = An invalid handle array was specified.
; Author ........: KryziK
; Modified ......: 1/12/2013
; Remarks .......:
; Related .......:
; Link ..........: http://msdn.microsoft.com/en-us/library/windows/desktop/ms724211.aspx
; Example .......: _Process_Close($ahHandle)
; ===============================================================================================================================
Func _Process_Close($ahHandle)
	If Not IsArray($ahHandle) Then
		SetError(1, 0, False)
		;Return False
	EndIf

	Local $ahCall = DllCall($ahHandle[0], "bool", "CloseHandle", _
			"handle", $ahHandle[1])

	DllClose($ahHandle[0])

	Return $ahCall[0]
EndFunc   ;==>_Process_Close

Func _MemoryRead64($ivAddress, $ahHandle, $sType = "dword", $value_type00="Hex")
	If Not IsArray($ahHandle) Then
		SetError(1, 0, False)
		;Return False
	EndIf


	Local $vReadData = DllStructCreate("dword_ptr") ; hex > dec
	If $value_type00="Dec" Then
	Local $vReadData01 = DllStructCreate($sType) ; hex array bytes

	ElseIf $value_type00="Array" Then
    Local $vReadData01 = DllStructCreate($sType) ; hex array bytes
	Local $vReadData = $vReadData01

	ElseIf $value_type00="Hex" Then
	Local $vReadData01 = DllStructCreate($sType) ; hex array bytes

	EndIf

	Local $vNumberOfBytesRead = DllStructCreate("ulong_ptr lpNumberOfBytesRead")

	Local $ahCall = DllCall($ahHandle[0], "bool", "ReadProcessMemory", _
			"handle", $ahHandle[1], _
			"dword_ptr", $ivAddress, _
			"ptr", DllStructGetPtr($vReadData), _
			"ulong_ptr", DllStructGetSize($vReadData01), _
			"ptr", DllStructGetPtr($vNumberOfBytesRead))
	;ConsoleWrite(DllStructGetData($vNumberOfBytesRead, "lpNumberOfBytesRead") & @CRLF & DllStructGetSize($vReadData01) & @CRLF)
	If (Not $ahCall[0]) Or (DllStructGetData($vNumberOfBytesRead, "lpNumberOfBytesRead") <> DllStructGetSize($vReadData01)) Then
		SetError(2, 0, False)
		;Return False
	EndIf

	If $value_type00 <> "Hex" Then Return DllStructGetData($vReadData, 1)
     If $value_type00 = "Hex" Then Return Hex("0x"&(DllStructGetData($vReadData, 1)))

EndFunc   ;==>_Process_ReadMemory



Func _MemoryWrite64($ivAddress, $ahHandle, $vData, $sType = "dword")
	If Not IsArray($ahHandle) Then
		SetError(1, 0, False)
		;Return False
	EndIf

	Local $vWriteData = DllStructCreate($sType)
	Local $vNumberOfBytesWritten = DllStructCreate("ulong_ptr lpNumberOfBytesWritten")

	DllStructSetData($vWriteData, 1, $vData)

	Local $ahCall = DllCall($ahHandle[0], "bool", "WriteProcessMemory", _
			"handle", $ahHandle[1], _
			"dword_ptr", $ivAddress, _
			"ptr", DllStructGetPtr($vWriteData), _
			"ulong_ptr", DllStructGetSize($vWriteData), _
			"ptr", DllStructGetPtr($vNumberOfBytesWritten))

	Return ($ahCall[0] And (DllStructGetData($vNumberOfBytesWritten, "lpNumberOfBytesWritten") = DllStructGetSize($vWriteData)))
EndFunc   ;==>_Process_WriteMemory


; #FUNCTION# ====================================================================================================================
; Name ..........: _Module_GetBaseAddress
; Description ...: Gets the base address of a module in the process associated with an array returned by _Process_Open.
; Syntax ........: _Module_GetBaseAddress($ahHandle, $sModuleName)
; Parameters ....: $ahHandle            - An array of handles.
;                  $sModuleName         - A string value.
;											The name of the module.
; Return values .: An integer value. The base address of the module in the open process.
;				   @error -		0 = No error occurred.
;								1 = An invalid handle array was specified.
;								2 = An error occurred while obtaining the first module of the process.
; Author ........: KryziK
; Modified ......: 1/12/2013
; Remarks .......:
; Related .......:
; Link ..........: http://msdn.microsoft.com/en-us/library/windows/desktop/ms682489.aspx
;				   http://msdn.microsoft.com/en-us/library/windows/desktop/ms684218.aspx
;				   http://msdn.microsoft.com/en-us/library/windows/desktop/ms684221.aspx
;				   http://msdn.microsoft.com/en-us/library/windows/desktop/ms724211.aspx
; Example .......: _Module_GetBaseAddress($ahHandle, "KryziK.dll")
; ===============================================================================================================================
Func _Module_GetBaseAddress($ahHandle, $sModuleName)
	If Not IsArray($ahHandle) Then
		SetError(1, 0, False)
		;Return False
	EndIf

	Local $ahSnapshot = DllCall($ahHandle[0], "handle", "CreateToolhelp32Snapshot", _
			"dword", BitOR($TH32CS_SNAPMODULE, $TH32CS_SNAPMODULE32), _
			"dword", $ahHandle[2])

	Local $vModuleEntry32 = DllStructCreate("dword dwSize;" & _
			"dword th32ModuleID;" & _
			"dword th32ProcessID;" & _
			"dword GlblcntUsage;" & _
			"dword ProccntUsage;" & _
			"ptr modBaseAddr;" & _
			"dword modBaseSize;" & _
			"handle hModule;" & _
			"char szModule[256];" & _
			"char szExePath[260]")

	DllStructSetData($vModuleEntry32, "dwSize", DllStructGetSize($vModuleEntry32))

	Local $ahCall = DllCall($ahHandle[0], "bool", "Module32First", _
			"handle", $ahSnapshot[0], _
			"ptr", DllStructGetPtr($vModuleEntry32))

	If Not $ahCall[0] Then
		DllCall($ahHandle[0], "bool", "CloseHandle", _
				"handle", $ahSnapshot[0])
		SetError(2, 0, False)
		;Return False
	EndIf

	Do
		If DllStructGetData($vModuleEntry32, "szModule") = $sModuleName Then
			DllCall($ahHandle[0], "bool", "CloseHandle", _
					"handle", $ahSnapshot[0])

			Return DllStructGetData($vModuleEntry32, "modBaseAddr")
		EndIf

		$ahCall = DllCall($ahHandle[0], "bool", "Module32Next", _
				"handle", $ahSnapshot[0], _
				"ptr", DllStructGetPtr($vModuleEntry32))
	Until Not $ahCall[0]

	DllCall($ahHandle[0], "bool", "CloseHandle", _
			"handle", $ahSnapshot[0])

	Return False
EndFunc   ;==>_Module_GetBaseAddress


; end 64bit-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

; Version 1.0 use NomadMemory, fix 3.50 -2
#include-once
#region _Memory
;==================================================================================
; AutoIt Version:	3.1.127 (beta)
; Language:			English
; Platform:			All Windows
; Author:			Nomad
; Requirements:		These functions will only work with beta.
;==================================================================================
; Credits:	wOuter - These functions are based on his original _Mem() functions.
;			But they are easier to comprehend and more reliable.  These
;			functions are in no way a direct copy of his functions.  His
;			functions only provided a foundation from which these evolved.
;==================================================================================
;
; Functions:
;
;==================================================================================
; Function:			_MemoryOpen($iv_Pid[, $iv_DesiredAccess[, $iv_InheritHandle]])
; Description:		Opens a process and enables all possible access rights to the
;					process.  The Process ID of the process is used to specify which
;					process to open.  You must call this function before calling
;					_MemoryClose(), _MemoryRead(), or _MemoryWrite().
; Parameter(s):		$iv_Pid - The Process ID of the program you want to open.
;					$iv_DesiredAccess - (optional) Set to 0x1F0FFF by default, which
;										enables all possible access rights to the
;										process specified by the Process ID.
;					$iv_InheritHandle - (optional) If this value is TRUE, all processes
;										created by this process will inherit the access
;										handle.  Set to 1 (TRUE) by default.  Set to 0
;										if you want it FALSE.
; Requirement(s):	None.
; Return Value(s): 	On Success - Returns an array containing the Dll handle and an
;								 open handle to the specified process.
;					On Failure - Returns 0
;					@Error - 0 = No error.
;							 1 = Invalid $iv_Pid.
;							 2 = Failed to open Kernel32.dll.
;							 3 = Failed to open the specified process.
; Author(s):		Nomad
; Note(s):
;==================================================================================
Func _MemoryOpen($iv_Pid, $iv_DesiredAccess = 0x1F0FFF, $iv_InheritHandle = 1)

	If Not ProcessExists($iv_Pid) Then
		SetError(1)
        Return 0
	EndIf

	Local $ah_Handle[2] = [DllOpen('kernel32.dll')]

	If @Error Then
        SetError(2)
        Return 0
    EndIf

	Local $av_OpenProcess = DllCall($ah_Handle[0], 'int', 'OpenProcess', 'int', $iv_DesiredAccess, 'int', $iv_InheritHandle, 'int', $iv_Pid)

	If @Error Then
        DllClose($ah_Handle[0])
        SetError(3)
        Return 0
    EndIf

	$ah_Handle[1] = $av_OpenProcess[0]

	Return $ah_Handle

EndFunc

;==================================================================================
; Function:			_MemoryRead($iv_Address, $ah_Handle[, $sv_Type])
; Description:		Reads the value located in the memory address specified.
; Parameter(s):		$iv_Address - The memory address you want to read from. It must
;								  be in hex format (0x00000000).
;					$ah_Handle - An array containing the Dll handle and the handle
;								 of the open process as returned by _MemoryOpen().
;					$sv_Type - (optional) The "Type" of value you intend to read.
;								This is set to 'dword'(32bit(4byte) signed integer)
;								by default.  See the help file for DllStructCreate
;								for all types.  An example: If you want to read a
;								word that is 15 characters in length, you would use
;								'char[16]' since a 'char' is 8 bits (1 byte) in size.
; Return Value(s):	On Success - Returns the value located at the specified address.
;					On Failure - Returns 0
;					@Error - 0 = No error.
;							 1 = Invalid $ah_Handle.
;							 2 = $sv_Type was not a string.
;							 3 = $sv_Type is an unknown data type.
;							 4 = Failed to allocate the memory needed for the DllStructure.
;							 5 = Error allocating memory for $sv_Type.
;							 6 = Failed to read from the specified process.
; Author(s):		Nomad
; Note(s):			Values returned are in Decimal format, unless specified as a
;					'char' type, then they are returned in ASCII format.  Also note
;					that size ('char[size]') for all 'char' types should be 1
;					greater than the actual size.
;==================================================================================
Func _MemoryRead($iv_Address, $ah_Handle, $sv_Type = 'dword')

	If Not IsArray($ah_Handle) Then
		SetError(1)
        Return 0
	EndIf

	Local $v_Buffer = DllStructCreate($sv_Type)

	If @Error Then
		SetError(@Error + 1)
		Return 0
	EndIf

	DllCall($ah_Handle[0], 'int', 'ReadProcessMemory', 'int', $ah_Handle[1], 'int', $iv_Address, 'ptr', DllStructGetPtr($v_Buffer), 'int', DllStructGetSize($v_Buffer), 'int', '')

	If Not @Error Then
		Local $v_Value = DllStructGetData($v_Buffer, 1)
		Return $v_Value
	Else
		SetError(6)
        Return 0
	EndIf

EndFunc

; read flip
Func _MemoryReadF($iv_Address, $ah_Handle, $sv_Type = 'dword')

	If Not IsArray($ah_Handle) Then
		SetError(1)
        Return 0
	EndIf

	Local $v_Buffer = DllStructCreate($sv_Type)

	If @Error Then
		SetError(@Error + 1)
		Return 0
	EndIf

	DllCall($ah_Handle[0], 'int', 'ReadProcessMemory', 'int', $ah_Handle[1], 'int', $iv_Address, 'ptr', DllStructGetPtr($v_Buffer), 'int', DllStructGetSize($v_Buffer), 'int', '')

	If Not @Error Then
		Local $v_Value = DllStructGetData($v_Buffer, 1)

Local $v_flipend = ""
For $i = 1 to DllStructGetSize($v_Buffer)
Local $v_flip = StringMid($v_Value,1+((DllStructGetSize($v_Buffer)+1-$i)*2),2)
      $v_flipend = $v_flipend&$v_flip
Next
Local $v_Value = dec($v_flipend)

		Return $v_Value
	Else
		SetError(6)
        Return 0
	EndIf

EndFunc

; read flip
Func _ReadF($readflip00,$decon00=0)
      $readflip00 = hex($readflip00)
      $bytes_readflip00 = StringLen($readflip00)/2
	  $v_flipend = ""
For $i = 1 to $bytes_readflip00
      $v_flip = StringMid($readflip00,-1+(($bytes_readflip00+1-$i)*2),2)
      $v_flipend = $v_flipend&$v_flip
Next
      If $decon00 = 0 then
	  $v_Value = $v_flipend
	  ElseIf $decon00 = 1 then
	  $v_Value = dec($v_flipend)
      EndIf
Return $v_Value
EndFunc

; _ReadOffset
Func _ReadOffset($Address00, $ah_Handle, $Offset01=-1, $Offset02=-1, $Offset03=-1, $Offset04=-1, $Offset05=-1, $Offset06=-1, $Offset07=-1, $Offset08=-1, $Offset09=-1)
	$Read_Offset00 = _MemoryReadF($Address00, $ah_Handle,'byte[4]')
	If $Offset01 <> -1 then
	$Read_Offset00 = _MemoryReadF($Read_Offset00+$Offset01, $ah_Handle,'byte[4]')
	EndIf
	If $Offset02 <> -1 then
	$Read_Offset00 = _MemoryReadF($Read_Offset00+$Offset02, $ah_Handle,'byte[4]')
	EndIf
	If $Offset03 <> -1 then
	$Read_Offset00 = _MemoryReadF($Read_Offset00+$Offset03, $ah_Handle,'byte[4]')
	EndIf
	If $Offset04 <> -1 then
	$Read_Offset00 = _MemoryReadF($Read_Offset00+$Offset04, $ah_Handle,'byte[4]')
	EndIf
	If $Offset05 <> -1 then
	$Read_Offset00 = _MemoryReadF($Read_Offset00+$Offset05, $ah_Handle,'byte[4]')
	EndIf
	If $Offset06 <> -1 then
	$Read_Offset00 = _MemoryReadF($Read_Offset00+$Offset06, $ah_Handle,'byte[4]')
	EndIf
	If $Offset07 <> -1 then
	$Read_Offset00 = _MemoryReadF($Read_Offset00+$Offset07, $ah_Handle,'byte[4]')
	EndIf
	If $Offset08 <> -1 then
	$Read_Offset00 = _MemoryReadF($Read_Offset00+$Offset08, $ah_Handle,'byte[4]')
	EndIf
	If $Offset09 <> -1 then
	$Read_Offset00 = _MemoryReadF($Read_Offset00+$Offset09, $ah_Handle,'byte[4]')
	EndIf
	Return $Read_Offset00
	EndFunc

;==================================================================================
; Function:			_MemoryWrite($iv_Address, $ah_Handle, $v_Data[, $sv_Type])
; Description:		Writes data to the specified memory address.
; Parameter(s):		$iv_Address - The memory address which you want to write to.
;								  It must be in hex format (0x00000000).
;					$ah_Handle - An array containing the Dll handle and the handle
;								 of the open process as returned by _MemoryOpen().
;					$v_Data - The data to be written.
;					$sv_Type - (optional) The "Type" of value you intend to write.
;								This is set to 'dword'(32bit(4byte) signed integer)
;								by default.  See the help file for DllStructCreate
;								for all types.  An example: If you want to write a
;								word that is 15 characters in length, you would use
;								'char[16]' since a 'char' is 8 bits (1 byte) in size.
; Return Value(s):	On Success - Returns 1
;					On Failure - Returns 0
;					@Error - 0 = No error.
;							 1 = Invalid $ah_Handle.
;							 2 = $sv_Type was not a string.
;							 3 = $sv_Type is an unknown data type.
;							 4 = Failed to allocate the memory needed for the DllStructure.
;							 5 = Error allocating memory for $sv_Type.
;							 6 = $v_Data is not in the proper format to be used with the
;								 "Type" selected for $sv_Type, or it is out of range.
;							 7 = Failed to write to the specified process.
; Author(s):		Nomad
; Note(s):			Values sent must be in Decimal format, unless specified as a
;					'char' type, then they must be in ASCII format.  Also note
;					that size ('char[size]') for all 'char' types should be 1
;					greater than the actual size.
;==================================================================================
Func _MemoryWrite($iv_Address, $ah_Handle, $v_Data, $sv_Type = 'dword')

	If Not IsArray($ah_Handle) Then
		SetError(1)
        Return 0
	EndIf

	Local $v_Buffer = DllStructCreate($sv_Type)

	If @Error Then
		SetError(@Error + 1)
		Return 0
	Else
		DllStructSetData($v_Buffer, 1, $v_Data)
		If @Error Then
			SetError(6)
			Return 0
		EndIf
	EndIf

	DllCall($ah_Handle[0], 'int', 'WriteProcessMemory', 'int', $ah_Handle[1], 'int', $iv_Address, 'ptr', DllStructGetPtr($v_Buffer), 'int', DllStructGetSize($v_Buffer), 'int', '')

	If Not @Error Then
		Return 1
	Else
		SetError(7)
        Return 0
	EndIf

EndFunc

; array write memory
Func _MemoryWriteA($iv_Address, $ah_Handle, $v_Data, $sv_Type = 'dword')

	If Not IsArray($ah_Handle) Then
		SetError(1)
        Return 0
	EndIf

	Local $v_Buffer = DllStructCreate($sv_Type)

	If @Error Then
		SetError(@Error + 1)
		Return 0
	Else
		For $i = 1 To DllStructGetSize($v_Buffer)
			DllStructSetData($v_Buffer, 1, Dec(StringMid($v_Data, ($i-1) * 2 + 1, 2)), $i)
		Next
		If @Error Then
			SetError(6)
			Return 0
		EndIf
	EndIf

	DllCall($ah_Handle[0], 'int', 'WriteProcessMemory', 'int', $ah_Handle[1], 'int', $iv_Address, 'ptr', DllStructGetPtr($v_Buffer), 'int', DllStructGetSize($v_Buffer), 'int', '')

	If Not @Error Then
		Return 1
	Else
		SetError(7)
        Return 0
	EndIf

EndFunc

;==================================================================================
; Function:			_MemoryClose($ah_Handle)
; Description:		Closes the process handle opened by using _MemoryOpen().
; Parameter(s):		$ah_Handle - An array containing the Dll handle and the handle
;								 of the open process as returned by _MemoryOpen().
; Return Value(s):	On Success - Returns 1
;					On Failure - Returns 0
;					@Error - 0 = No error.
;							 1 = Invalid $ah_Handle.
;							 2 = Unable to close the process handle.
; Author(s):		Nomad
; Note(s):
;==================================================================================
Func _MemoryClose($ah_Handle)

	If Not IsArray($ah_Handle) Then
		SetError(1)
        Return 0
	EndIf

	DllCall($ah_Handle[0], 'int', 'CloseHandle', 'int', $ah_Handle[1])
	If Not @Error Then
		DllClose($ah_Handle[0])
		Return 1
	Else
		DllClose($ah_Handle[0])
		SetError(2)
        Return 0
	EndIf

EndFunc

;==================================================================================
; Function:			SetPrivilege( $privilege, $bEnable )
; Description:		Enables (or disables) the $privilege on the current process
;                   (Probably) requires administrator privileges to run
;
; Author(s):		Larry (from autoitscript.com's Forum)
; Notes(s):
; http://www.autoitscript.com/forum/index.php?s=&showtopic=31248&view=findpost&p=223999
;==================================================================================

Func SetPrivilege( $privilege, $bEnable )
    Const $TOKEN_ADJUST_PRIVILEGES = 0x0020
    Const $TOKEN_QUERY = 0x0008
    Const $SE_PRIVILEGE_ENABLED = 0x0002
    Local $hToken, $SP_auxret, $SP_ret, $hCurrProcess, $nTokens, $nTokenIndex, $priv
    $nTokens = 1
    $LUID = DLLStructCreate("dword;int")
    If IsArray($privilege) Then    $nTokens = UBound($privilege)
    $TOKEN_PRIVILEGES = DLLStructCreate("dword;dword[" & (3 * $nTokens) & "]")
    $NEWTOKEN_PRIVILEGES = DLLStructCreate("dword;dword[" & (3 * $nTokens) & "]")
    $hCurrProcess = DLLCall("kernel32.dll","hwnd","GetCurrentProcess")
    $SP_auxret = DLLCall("advapi32.dll","int","OpenProcessToken","hwnd",$hCurrProcess[0],   _
            "int",BitOR($TOKEN_ADJUST_PRIVILEGES,$TOKEN_QUERY),"int_ptr",0)
    If $SP_auxret[0] Then
        $hToken = $SP_auxret[3]
        DLLStructSetData($TOKEN_PRIVILEGES,1,1)
        $nTokenIndex = 1
        While $nTokenIndex <= $nTokens
            If IsArray($privilege) Then
                $priv = $privilege[$nTokenIndex-1]
            Else
                $priv = $privilege
            EndIf
            $ret = DLLCall("advapi32.dll","int","LookupPrivilegeValue","str","","str",$priv,   _
                    "ptr",DLLStructGetPtr($LUID))
            If $ret[0] Then
                If $bEnable Then
                    DLLStructSetData($TOKEN_PRIVILEGES,2,$SE_PRIVILEGE_ENABLED,(3 * $nTokenIndex))
                Else
                    DLLStructSetData($TOKEN_PRIVILEGES,2,0,(3 * $nTokenIndex))
                EndIf
                DLLStructSetData($TOKEN_PRIVILEGES,2,DllStructGetData($LUID,1),(3 * ($nTokenIndex-1)) + 1)
                DLLStructSetData($TOKEN_PRIVILEGES,2,DllStructGetData($LUID,2),(3 * ($nTokenIndex-1)) + 2)
                DLLStructSetData($LUID,1,0)
                DLLStructSetData($LUID,2,0)
            EndIf
            $nTokenIndex += 1
        WEnd
        $ret = DLLCall("advapi32.dll","int","AdjustTokenPrivileges","hwnd",$hToken,"int",0,   _
                "ptr",DllStructGetPtr($TOKEN_PRIVILEGES),"int",DllStructGetSize($NEWTOKEN_PRIVILEGES),   _
                "ptr",DllStructGetPtr($NEWTOKEN_PRIVILEGES),"int_ptr",0)
        $f = DLLCall("kernel32.dll","int","GetLastError")
    EndIf
    $NEWTOKEN_PRIVILEGES=0
    $TOKEN_PRIVILEGES=0
    $LUID=0
    If $SP_auxret[0] = 0 Then Return 0
    $SP_auxret = DLLCall("kernel32.dll","int","CloseHandle","hwnd",$hToken)
    If Not $ret[0] And Not $SP_auxret[0] Then Return 0
    return $ret[0]
EndFunc   ;==>SetPrivilege



;==================================================================================
;  new func
;  _MemoryModuleGetBaseAddress($iPID, $sModule) ; ($control01,file.dll)
; _ReadWriteOpcode($jmp00_next,$opcode00,$newmem00,$registers00,$firstlast00,$read_write00) ; ($jmp00_next,$opcode00,$newmem00,"eax","last","read")
; _VirtualProtectEx($iv_Address, $ah_Handle,$page00) ; ($iv_Address, $ah_Handle,$page00) $PAGE_READONLY $PAGE_READWRITE
;==================================================================================

Func _MemoryModuleGetBaseAddress($iPID, $sModule)
       If Not ProcessExists($iPID) Then Return SetError(1, 0, 0)

       If Not IsString($sModule) Then Return SetError(2, 0, 0)

       Local   $PSAPI = DllOpen("psapi.dll")

       ;Get Process Handle
       Local   $hProcess
       Local   $PERMISSION = BitOR(0x0002, 0x0400, 0x0008, 0x0010, 0x0020) ; CREATE_THREAD, QUERY_INFORMATION, VM_OPERATION, VM_READ, VM_WRITE

       If $iPID > 0 Then
           Local $hProcess = DllCall("kernel32.dll", "ptr", "OpenProcess", "dword", $PERMISSION, "int", 0, "dword", $iPID)
           If $hProcess[0] Then
               $hProcess = $hProcess[0]
           EndIf
       EndIf

       ;EnumProcessModules
       Local   $Modules = DllStructCreate("ptr[1024]")
       Local   $aCall = DllCall($PSAPI, "int", "EnumProcessModules", "ptr", $hProcess, "ptr", DllStructGetPtr($Modules), "dword", DllStructGetSize($Modules), "dword*", 0)
       If $aCall[4] > 0 Then
           Local   $iModnum = $aCall[4] / 4
           Local   $aTemp
          For $i = 1 To $iModnum
              $aTemp =  DllCall($PSAPI, "dword", "GetModuleBaseNameW", "ptr", $hProcess, "ptr", Ptr(DllStructGetData($Modules, 1, $i)), "wstr", "", "dword", 260)
              If $aTemp[3] = $sModule Then
                  DllClose($PSAPI)
                  Return Ptr(DllStructGetData($Modules, 1, $i))
              EndIf
          Next
      EndIf

      DllClose($PSAPI)
      Return SetError(-1, 0, 0)

  EndFunc

Func _ReadWriteOpcode($jmp00_next,$opcode00,$newmem00,$registers00,$firstlast00,$read_write00) ; ($jmp00_next,$opcode00,$newmem00,"eax","last","read")
$registers00_hex_mem = 0x4
$registers00_hex = $registers00

If $read_write00 = "read" and $registers00 = "eax" then
$registers00_hex = "8905"
ElseIf $read_write00 = "read" and $registers00 = "ebx" then
$registers00_hex = "891D"
ElseIf $read_write00 = "read" and $registers00 = "ecx" then
$registers00_hex = "890D"
ElseIf $read_write00 = "read" and $registers00 = "edx" then
$registers00_hex = "8915"
ElseIf $read_write00 = "read" and $registers00 = "esi" then
$registers00_hex = "8935"
ElseIf $read_write00 = "read" and $registers00 = "edi" then
$registers00_hex = "893D"
ElseIf $read_write00 = "read" and $registers00 = "ebp" then
$registers00_hex = "892D"
ElseIf $read_write00 = "read" and $registers00 = "esp" then
$registers00_hex = "8925"
ElseIf $read_write00 = "read" and $registers00 = "ax" then
$registers00_hex = "66A3"
ElseIf $read_write00 = "read" and $registers00 = "bx" then
$registers00_hex = "66891D"
ElseIf $read_write00 = "read" and $registers00 = "cx" then
$registers00_hex = "66890D"
ElseIf $read_write00 = "read" and $registers00 = "dx" then
$registers00_hex = "668915"
EndIf

If $read_write00 = "write" and $registers00 = "eax" then
$registers00_hex = "A1"
ElseIf $read_write00 = "write" and $registers00 = "ebx" then
$registers00_hex = "8B1D"
ElseIf $read_write00 = "write" and $registers00 = "ecx" then
$registers00_hex = "8B0D"
ElseIf $read_write00 = "write" and $registers00 = "edx" then
$registers00_hex = "8B15"
ElseIf $read_write00 = "write" and $registers00 = "esi" then
$registers00_hex = "8B35"
ElseIf $read_write00 = "write" and $registers00 = "edi" then
$registers00_hex = "8B3D"
ElseIf $read_write00 = "write" and $registers00 = "ebp" then
$registers00_hex = "8B2D"
ElseIf $read_write00 = "write" and $registers00 = "esp" then
$registers00_hex = "8B25"
ElseIf $read_write00 = "write" and $registers00 = "ax" then
$registers00_hex = "668B05"
ElseIf $read_write00 = "write" and $registers00 = "bx" then
$registers00_hex = "668B1D"
ElseIf $read_write00 = "write" and $registers00 = "cx" then
$registers00_hex = "668B0D"
ElseIf $read_write00 = "write" and $registers00 = "dx" then
$registers00_hex = "668B15"
EndIf

; stringlen
If $read_write00 = "free" then
$registers00_hex_mem = 0x0
EndIf
If $firstlast00 = "first" then
$mov00_back_add = $newmem00+0x4
$opcode00_add = $mov00_back_add + ($registers00_hex_mem+StringLen($registers00_hex)/2)
$jmp00_back_add = $opcode00_add+(StringLen($opcode00)/2)
ElseIf $firstlast00 = "last" then
$opcode00_add = $newmem00+0x4
$mov00_back_add = $opcode00_add+(StringLen($opcode00)/2)
$jmp00_back_add = $mov00_back_add + ($registers00_hex_mem+StringLen($registers00_hex)/2)
EndIf
$jmp00_back = $jmp00_next+(StringLen($opcode00)/2)

; jmp opcode
_MemoryWriteA($opcode00_add, $procHwnd01, $opcode00,"byte["&StringLen($opcode00)/2&"]")

; mov back
$mov00_back_op = $registers00_hex&(_ReadF($newmem00,0)) ; _ReadF($readflip00,$decon00)

; opcode free
If $read_write00 = "free" then
$mov00_back_op = $registers00_hex ; _ReadF($readflip00,$decon00)
EndIf

_MemoryWriteA($mov00_back_add, $procHwnd01, $mov00_back_op,"byte["&StringLen($mov00_back_op)/2&"]")

; jmp back
$jmp00_back_op = 0xFFFFFFFF - ($jmp00_back_add-$jmp00_back + 0x4)
$jmp00_back_op = "E9"&(_ReadF($jmp00_back_op,0)) ; _ReadF($readflip00,$decon00)
_MemoryWriteA($jmp00_back_add, $procHwnd01, $jmp00_back_op,"byte["&StringLen($jmp00_back_op)/2&"]")

; jmp next
$jmp00_next_op = ($newmem00+0x4) - $jmp00_next - 0x5; + 0x82 - 0x7F
$jmp00_next_op = "E9"&(_ReadF($jmp00_next_op,0)) ; _ReadF($readflip00,$decon00)
_MemoryWriteA($jmp00_next, $procHwnd01, $jmp00_next_op,"byte["&StringLen($jmp00_next_op)/2&"]")

EndFunc

Func _BackOpcode($jmp00_next,$opcode00) ; ($jmp00_next,$opcode00)
_MemoryWriteA($jmp00_next, $procHwnd01, $opcode00,"byte["&StringLen($opcode00)/2&"]")
EndFunc

Func _VirtualProtectEx($iv_Address, $ah_Handle,$page00) ; ($iv_Address, $ah_Handle,$page00) $PAGE_READONLY $PAGE_READWRITE

	If Not IsArray($ah_Handle) Then
		SetError(1)
        Return 0
	EndIf

	DllCall($ah_Handle[0], 'int', 'VirtualProtectEx', 'int',  $ah_Handle[1], 'ptr', $iv_Address, 'ulong_ptr', 2, 'dword', $page00, 'dword*', '')

	If Not @Error Then
		Return 1
	Else
		SetError(7)
        Return 0
	EndIf

EndFunc

	;=================================================================================================
; Function:			_VirtualQueryEx($iv_Address, $ah_Handle)
; Description:		Opens a process then reads and returns information for the memory page which
;					contains the memory address specified.
; Parameter(s):		$iv_Address - The memory address you want to read from. It must be in hex
;								  format (0x00000000).
;					$ah_Handle - An array containing the Dll handle and the handle of the open
;								 process as returned by _MemoryOpen().
; Requirement(s):	A valid process ID.
; Return Value(s): 	On Success - Returns an array containing the following:
;								 $Array[0] = Base Address.
;								 $Array[1] = Allocation Base.
;								 $Array[2] = Allocation Protect.
;                                0x10 = PAGE_EXECUTE 0x20 = PAGE_EXECUTE_READ 0x40 = PAGE_EXECUTE_READWRITE 0x80 = PAGE_EXECUTE_WRITECOPY
;                                0x1 = PAGE_NOACCESS 0x2 = PAGE_READONLY 0x4 = PAGE_READWRITE 0x8 = PAGE_WRITECOPY
;								 $Array[3] = Region Size.
;								 $Array[4] = State.
;								 $Array[5] = Protect.
;								 $Array[6] = Type.
;					On Failure - Returns 0
;					@Error - 0 = No error.
;							 1 = Invalid $ah_Handle.
;							 2 = $sv_Type was not a string.
;							 3 = $sv_Type is an unknown data type.
;							 4 = Failed to allocate the memory needed for the DllStructure.
;							 5 = Error allocating memory for $sv_Type.
;							 6 = Failed to read from the specified process.
; Author(s):		Nomad
; Note(s):
;=================================================================================================

Func _VirtualQueryEx($iv_Address, $ah_Handle)

	If Not IsArray($ah_Handle) Then
		SetError(1)
        Return 0
	EndIf

	Local $av_Data[10], $i
	;If @AutoItX64 = 0 Then Local $v_Buffer = DllStructCreate('dword;dword;dword;dword;dword;dword;dword') ; 32bit
    Local $v_Buffer = DllStructCreate('ULONG_PTR;ULONG_PTR;ULONG_PTR;ULONG_PTR;ULONG_PTR;ULONG_PTR;ULONG_PTR;ULONG_PTR;ULONG_PTR') ; 64bit


	If @Error Then
		SetError(@Error + 1)
		Return 0
	EndIf

	DllCall($ah_Handle[0], 'int', 'VirtualQueryEx', 'int', $ah_Handle[1], 'int', $iv_Address, 'ptr', DllStructGetPtr($v_Buffer), 'int', DllStructGetSize($v_Buffer))

	If Not @Error Then
		For $i = 0 to 6
			$av_Data[$i] = Hex(DllStructGetData($v_Buffer, ($i + 1)))
		Next
		Return $av_Data
	Else
		SetError(6)
        Return 0
	EndIf
EndFunc

; hook dll

Func _InjectDll($hWnd, $dllpath) ; $control01, "d:\speedhack.dll"
	;make sure the user passed valid parameters
	If $hWnd <= 0 Then
		SetError(-1)
		Return False
	ElseIf StringLen($dllpath) <= 4 Or StringRight($dllpath, 4) <> ".dll" Then
		SetError(-2)
		Return False
	EndIf

	Local $pid, $pHandle, $pLibRemote, $modHandle, $LoadLibraryA, $hThread

	;open dll that we'll be using
	Local $kernel32 = DllOpen("kernel32.dll")

	;get the pid from the window provided
	$pid = DllCall("user32.dll", "int", "GetWindowThreadProcessId", "hwnd", $hWnd, "int*", 0)
	If IsArray($pid) Then
		$pid = $pid[2]
	Else
		SetError(-3)
		Return False
	EndIf

	;open the process for writing
	$pHandle = DllCall($kernel32, "int", "OpenProcess", "int", 0x1F0FFF, "int", 0, "int", $pid)
	If IsArray($pHandle) And $pHandle[0] > 0 Then
		$pHandle = $pHandle[0]
	Else
		SetError(-4)
		Return False
	EndIf

	$pLibRemote = DllCall($kernel32, "int", "VirtualAllocEx", "int", $pHandle, "short", 0, "int", 0x1000, "int", 0x1000, "int", 4)
	If IsArray($pLibRemote) Then
		If $pLibRemote[0] > 0 Then
			;debug
			;ConsoleWrite("0x" & Hex($pLibRemote[0], 8) & @CR)
			$pLibRemote = $pLibRemote[0]
		Else
			SetError(-5)
			Return False
		EndIf
	Else
		SetError(-6)
		Return False
	EndIf

	For $i = 0 To StringLen($dllpath)
		$ret = DllCall("kernel32.dll", "int", "WriteProcessMemory", "int", $pHandle, "int", $pLibRemote + $i, "int*", Asc(StringMid($dllpath, $i + 1, 1)), "int", 1, "int", 0)
		If IsArray($ret) Then
			If $ret[0] = 0 Then
				SetError(-7)
				Return False
			EndIf
		Else
			SetError(-8)
			Return False
		EndIf
	Next

	$modHandle = DllCall($kernel32, "long", "GetModuleHandle", "str", "kernel32.dll")
	If IsArray($modHandle) Then
		If $modHandle[0] > 0 Then
			$modHandle = $modHandle[0]
		Else
			SetError(-9)
			Return False
		EndIf
	Else
		SetError(-10)
		Return False
	EndIf

	$LoadLibraryA = DllCall($kernel32, "long", "GetProcAddress", "long", $modHandle, "str", "LoadLibraryA")
	If IsArray($LoadLibraryA) Then
		If $LoadLibraryA[0] > 0 Then
			$LoadLibraryA = $LoadLibraryA[0]
		Else
			SetError(-11)
			Return False
		EndIf
	Else
		SetError (-12)
		Return False
	EndIf

	$hThread = DllCall($kernel32, "int", "CreateRemoteThread", "int", $pHandle, "int", 0, "int", 0, "long", $LoadLibraryA, "long", $pLibRemote, "int", 0, "int", 0)
	;If IsArray($hThread) Then
	;	ConsoleWrite($hThread[0] & @CR)
	;	If $hThread[0] > 0 Then
	;		$hThread = $hThread[0]
	;	Else
	;		SetError(-13)
	;		Return False
	;	EndIf
	;Else
	;	SetError(-14)
	;	Return False
	;EndIf

	DllCall($kernel32, "int", "VirtualFreeEx", "int", $pHandle, "int", $pLibRemote, "int", 0x1000, "int", 0x8000)
	DllCall($kernel32, "int", "CloseHandle", "int", $hThread)
	DllCall($kernel32, "int", "CloseHandle", "int", $pHandle)

	DllClose($kernel32)

	Return True
EndFunc

Func _Float_Hex($Float00)
    $Float_d00 = DllStructCreate("float")
    $Ptr_d00 = DllStructCreate("ptr", DllStructGetPtr($Float_d00))
    If $Float00 = "" Then Exit
    DllStructSetData($Float_d00, 1, $Float00)
    $return = DllStructGetData($Ptr_d00, 1)
    Return $return
EndFunc

Func _Pause($iv_Pid, $text00) ; "pause" "return"
 Local $ah_Handle = DllCall("kernel32.dll", 'int', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $iv_Pid)
 If $text00 = "pause" Then
 Local $i_sucess = DllCall("ntdll.dll", "int", "NtSuspendProcess", "int", $ah_Handle[0])
 EndIf
 If $text00 = "return" Then
 Local $i_sucess = DllCall("ntdll.dll", "int", "NtResumeProcess", "int", $ah_Handle[0])
 EndIf
 DllCall ('kernel32.dll', 'ptr', 'CloseHandle', 'ptr', $ah_Handle)
EndFunc

Func VirtualAllocEx($ah_Handle, $iSize) ; $procHwnd01[1], $iSize
	Local $aResult = DllCall("Kernel32.dll", "ptr", "VirtualAllocEx", "int", $ah_Handle, "ptr", 0x0, "int", $iSize, "int", 0x1000, "int", 0x40)
	If @error Or Not IsArray($aResult) Then Return SetError(-1, -1, 0)
	Return $aResult[0]
EndFunc   ;==>VirtualAllocEx

#endregion



; get color no active handle 12/7/2016
;#RequireAdmin
;#include <WinAPI.au3>
;#include <WindowsConstants.au3>
;#include <GDIPlus.au3>
;#include <ScreenCapture.au3>
;#include <Array.au3>

Func _GetColor($gx0, $gy0, $WinHandle,$nFlags=3, $check0=0, $r0=10 &@CRLF& _
   "", $x0=0, $y0=0, $c0=0, $x1=0, $y1=0, $c1=0, $x2=0, $y2=0, $c2=0, $x3=0, $y3=0, $c3=0 &@CRLF& _
   "", $x4=0, $y4=0, $c4=0, $x5=0, $y5=0, $c5=0, $x6=0, $y6=0, $c6=0, $x7=0, $y7=0, $c7=0 &@CRLF& _
   "", $x8=0, $y8=0, $c8=0, $x9=0, $y9=0, $c9=0, $x10=0, $y10=0, $c10=0, $x11=0, $y11=0, $c11=0 &@CRLF& _
   "", $x12=0, $y12=0, $c12=0, $x13=0, $y13=0, $c13=0, $x14=0, $y14=0, $c14=0, $x15=0, $y15=0, $c15=0 &@CRLF& _
   "", $x16=0, $y16=0, $c16=0, $x17=0, $y17=0, $c17=0, $x18=0, $y18=0, $c18=0, $x19=0, $y19=0, $c19=0 &@CRLF& _
   "", $x20=0, $y20=0, $c20=0, $x21=0, $y21=0, $c21=0, $x22=0, $y22=0, $c22=0, $x23=0, $y23=0, $c23=0 &@CRLF& _
   "", $x24=0, $y24=0, $c24=0, $x25=0, $y25=0, $c25=0, $x26=0, $y26=0, $c26=0, $x27=0, $y27=0, $c27=0 &@CRLF& _
   "", $x28=0, $y28=0, $c28=0, $x29=0, $y29=0, $c29=0, $x30=0, $y30=0, $c30=0, $x31=0, $y31=0, $c31=0 &@CRLF& _
   "", $x32=0, $y32=0, $c32=0, $x33=0, $y33=0, $c33=0, $x34=0, $y34=0, $c34=0, $x35=0, $y35=0, $c35=0 &@CRLF& _
   "", $x36=0, $y36=0, $c36=0, $x37=0, $y37=0, $c37=0, $x38=0, $y38=0, $c38=0, $x39=0, $y39=0, $c39=0 &@CRLF& _
   "", $x40=0, $y40=0, $c40=0, $x41=0, $y41=0, $c41=0, $x42=0, $y42=0, $c42=0, $x43=0, $y43=0, $c43=0 &@CRLF& _
   "", $x44=0, $y44=0, $c44=0, $x45=0, $y45=0, $c45=0, $x46=0, $y46=0, $c46=0, $x47=0, $y47=0, $c47=0 &@CRLF& _
   "", $x48=0, $y48=0, $c48=0, $x49=0, $y49=0, $c49=0, $x50=0, $y50=0, $c50=0, $x51=0, $y51=0, $c51=0 &@CRLF& _
   "", $x52=0, $y52=0, $c52=0, $x53=0, $y53=0, $c53=0, $x54=0, $y54=0, $c54=0, $x55=0, $y55=0, $c55=0 &@CRLF& _
   "", $x56=0, $y56=0, $c56=0, $x57=0, $y57=0, $c57=0, $x58=0, $y58=0, $c58=0, $x59=0, $y59=0, $c59=0 &@CRLF& _
   "", $x60=0, $y60=0, $c60=0, $x61=0, $y61=0, $c61=0, $x62=0, $y62=0, $c62=0, $x63=0, $y63=0, $c63=0 &@CRLF& _
   "", $x64=0, $y64=0, $c64=0, $x65=0, $y65=0, $c65=0, $x66=0, $y66=0, $c66=0, $x67=0, $y67=0, $c67=0 &@CRLF& _
   "", $x68=0, $y68=0, $c68=0, $x69=0, $y69=0, $c69=0, $x70=0, $y70=0, $c70=0, $x71=0, $y71=0, $c71=0 &@CRLF& _
   "", $x72=0, $y72=0, $c72=0, $x73=0, $y73=0, $c73=0, $x74=0, $y74=0, $c74=0, $x75=0, $y75=0, $c75=0 &@CRLF& _
   "", $x76=0, $y76=0, $c76=0, $x77=0, $y77=0, $c77=0, $x78=0, $y78=0, $c78=0, $x79=0, $y79=0, $c79=0 &@CRLF& _
   "", $x80=0, $y80=0, $c80=0, $x81=0, $y81=0, $c81=0, $x82=0, $y82=0, $c82=0, $x83=0, $y83=0, $c83=0 &@CRLF& _
   "", $x84=0, $y84=0, $c84=0, $x85=0, $y85=0, $c85=0, $x86=0, $y86=0, $c86=0, $x87=0, $y87=0, $c87=0 &@CRLF& _
   "", $x88=0, $y88=0, $c88=0, $x89=0, $y89=0, $c89=0, $x90=0, $y90=0, $c90=0, $x91=0, $y91=0, $c91=0 &@CRLF& _
   "", $x92=0, $y92=0, $c92=0, $x93=0, $y93=0, $c93=0, $x94=0, $y94=0, $c94=0, $x95=0, $y95=0, $c95=0 &@CRLF& _
   "", $x96=0, $y96=0, $c96=0, $x97=0, $y97=0, $c97=0, $x98=0, $y98=0, $c98=0, $x99=0, $y99=0, $c99=0 &@CRLF& _
   "" )
;MsgBox("","check","01 = "&$r0&"  02 = "&$r0,0)
	Local $aPixelColor[100], $g_color[100]
    ; thiet lap thong so ham
    $iWidth = $gx0
    $iHeight = $gy0
	Local $g_x[100] = [$x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10, $x11, $x12, $x13, $x14, $x15, $x16, $x17, $x18, $x19 &@CRLF& _
				    "",$x20, $x21, $x22, $x23, $x24, $x25, $x26, $x27, $x28, $x29, $x30, $x31, $x32, $x33, $x34, $x35, $x36, $x37, $x38, $x39 &@CRLF& _
					"",$x40, $x41, $x42, $x43, $x44, $x45, $x46, $x47, $x48, $x49, $x50, $x51, $x52, $x53, $x54, $x55, $x56, $x57, $x58, $x59 &@CRLF& _
					"",$x60, $x61, $x62, $x63, $x64, $x65, $x66, $x67, $x68, $x69, $x70, $x71, $x72, $x73, $x74, $x75, $x76, $x77, $x78, $x79 &@CRLF& _
					"",$x80, $x81, $x82, $x83, $x84, $x85, $x86, $x87, $x88, $x89, $x90, $x91, $x92, $x93, $x94, $x95, $x96, $x97, $x98, $x99 &@CRLF& _
                ""]

    Local $g_y[100] = [$y0, $y1, $y2, $y3, $y4, $y5, $y6, $y7, $y8, $y9, $y10, $y11, $y12, $y13, $y14, $y15, $y16, $y17, $y18, $y19 &@CRLF& _
				    "",$y20, $y21, $y22, $y23, $y24, $y25, $y26, $y27, $y28, $y29, $y30, $y31, $y32, $y33, $y34, $y35, $y36, $y37, $y38, $y39 &@CRLF& _
					"",$y40, $y41, $y42, $y43, $y44, $y45, $y46, $y47, $y48, $y49, $y50, $y51, $y52, $y53, $y54, $y55, $y56, $y57, $y58, $y59 &@CRLF& _
					"",$y60, $y61, $y62, $y63, $y64, $y65, $y66, $y67, $y68, $y69, $y70, $y71, $y72, $y73, $y74, $y75, $y76, $y77, $y78, $y79 &@CRLF& _
					"",$y80, $y81, $y82, $y83, $y84, $y85, $y86, $y87, $y88, $y89, $y90, $y91, $y92, $y93, $y94, $y95, $y96, $y97, $y98, $y99 &@CRLF& _
                ""]

    Local $g_c[100] = [$c0, $c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8, $c9, $c10, $c11, $c12, $c13, $c14, $c15, $c16, $c17, $c18, $c19 &@CRLF& _
				    "",$c20, $c21, $c22, $c23, $c24, $c25, $c26, $c27, $c28, $c29, $c30, $c31, $c32, $c33, $c34, $c35, $c36, $c37, $c38, $c39 &@CRLF& _
					"",$c40, $c41, $c42, $c43, $c44, $c45, $c46, $c47, $c48, $c49, $c50, $c51, $c52, $c53, $c54, $c55, $c56, $c57, $c58, $c59 &@CRLF& _
					"",$c60, $c61, $c62, $c63, $c64, $c65, $c66, $c67, $c68, $c69, $c70, $c71, $c72, $c73, $c74, $c75, $c76, $c77, $c78, $c79 &@CRLF& _
					"",$c80, $c81, $c82, $c83, $c84, $c85, $c86, $c87, $c88, $c89, $c90, $c91, $c92, $c93, $c94, $c95, $c96, $c97, $c98, $c99 &@CRLF& _
                ""]


    _GDIPlus_Startup()

    Local $hDDC = _WinAPI_GetDC($WinHandle)
    Local $hCDC = _WinAPI_CreateCompatibleDC($hDDC)

    $hBMP = _WinCapture($WinHandle,$nFlags) ; toc do chap hon bat dc screen an pixel 2
    $BMP = _GDIPlus_BitmapCreateFromHBITMAP($hBMP)
    _WinAPI_DeleteObject($hBMP)
    If $check0 = 0 Then ; get color pixel

	For $lp_check01 = 0 to 99 ; kiem tra 1 to 99
    $aPixelColor[$lp_check01] = Hex(_GDIPlus_BitmapGetPixel($BMP, $g_x[$lp_check01], $g_y[$lp_check01]), 6)
    Next

    ElseIf $check0 = 1 Then ; kiem tra mau co trung nhau PixelSearch

	For $lp_check01 = 0 to 99 ; kiem tra 1 to 99
    $g_color[$lp_check01] = 0

	For $iY = -3 To 3
	   For $iX = -3 To 3
	$aPixelColor[$lp_check01] = Hex(_GDIPlus_BitmapGetPixel($BMP, $g_x[$lp_check01]+$iX, $g_y[$lp_check01]+$iY), 6)
	If $g_color[$lp_check01] = 0 Then  $g_color[$lp_check01] = _ColorSearch($g_x[$lp_check01], $g_y[$lp_check01], $g_c[$lp_check01], $aPixelColor[$lp_check01], $r0)

	;If $lp_check01 = 39 Then MsgBox("","check","xy = "&$g_x[$lp_check01]+$iX&","&$g_y[$lp_check01]+$iY&"  aPixelColor = "&$aPixelColor[$lp_check01]&"  $g_color = "&$g_color[$lp_check01],0)

	Next
    Next


   Next ; end kiem tra color

   EndIf ; end get color pixel

; end PixelSearch
    _WinAPI_ReleaseDC($WinHandle, $hDDC)
    _WinAPI_DeleteDC($hCDC)
    _WinAPI_DeleteObject($hBMP)
    _GDIPlus_ImageDispose($BMP)

    If $check0=0 Then Return $aPixelColor
    If $check0=1 Then Return $g_color
 EndFunc   ;==>_GetColor




Func _GetColorEX($gx0, $gy0, $WinHandle,$nFlags=3, $check0=0, $r0=10 &@CRLF& _
   "", $x0=0, $y0=0, $c0=0, $x1=0, $y1=0, $c1=0, $x2=0, $y2=0, $c2=0, $x3=0, $y3=0, $c3=0 &@CRLF& _
   "", $x4=0, $y4=0, $c4=0, $x5=0, $y5=0, $c5=0, $x6=0, $y6=0, $c6=0, $x7=0, $y7=0, $c7=0 &@CRLF& _
   "", $x8=0, $y8=0, $c8=0, $x9=0, $y9=0, $c9=0, $x10=0, $y10=0, $c10=0, $x11=0, $y11=0, $c11=0 &@CRLF& _
   "", $x12=0, $y12=0, $c12=0, $x13=0, $y13=0, $c13=0, $x14=0, $y14=0, $c14=0, $x15=0, $y15=0, $c15=0 &@CRLF& _
   "", $x16=0, $y16=0, $c16=0, $x17=0, $y17=0, $c17=0, $x18=0, $y18=0, $c18=0, $x19=0, $y19=0, $c19=0 &@CRLF& _
   "", $x20=0, $y20=0, $c20=0, $x21=0, $y21=0, $c21=0, $x22=0, $y22=0, $c22=0, $x23=0, $y23=0, $c23=0 &@CRLF& _
   "", $x24=0, $y24=0, $c24=0, $x25=0, $y25=0, $c25=0, $x26=0, $y26=0, $c26=0, $x27=0, $y27=0, $c27=0 &@CRLF& _
   "", $x28=0, $y28=0, $c28=0, $x29=0, $y29=0, $c29=0, $x30=0, $y30=0, $c30=0, $x31=0, $y31=0, $c31=0 &@CRLF& _
   "", $x32=0, $y32=0, $c32=0, $x33=0, $y33=0, $c33=0, $x34=0, $y34=0, $c34=0, $x35=0, $y35=0, $c35=0 &@CRLF& _
   "", $x36=0, $y36=0, $c36=0, $x37=0, $y37=0, $c37=0, $x38=0, $y38=0, $c38=0, $x39=0, $y39=0, $c39=0 &@CRLF& _
   "", $x40=0, $y40=0, $c40=0, $x41=0, $y41=0, $c41=0, $x42=0, $y42=0, $c42=0, $x43=0, $y43=0, $c43=0 &@CRLF& _
   "", $x44=0, $y44=0, $c44=0, $x45=0, $y45=0, $c45=0, $x46=0, $y46=0, $c46=0, $x47=0, $y47=0, $c47=0 &@CRLF& _
   "", $x48=0, $y48=0, $c48=0, $x49=0, $y49=0, $c49=0, $x50=0, $y50=0, $c50=0, $x51=0, $y51=0, $c51=0 &@CRLF& _
   "", $x52=0, $y52=0, $c52=0, $x53=0, $y53=0, $c53=0, $x54=0, $y54=0, $c54=0, $x55=0, $y55=0, $c55=0 &@CRLF& _
   "", $x56=0, $y56=0, $c56=0, $x57=0, $y57=0, $c57=0, $x58=0, $y58=0, $c58=0, $x59=0, $y59=0, $c59=0 &@CRLF& _
   "", $x60=0, $y60=0, $c60=0, $x61=0, $y61=0, $c61=0, $x62=0, $y62=0, $c62=0, $x63=0, $y63=0, $c63=0 &@CRLF& _
   "", $x64=0, $y64=0, $c64=0, $x65=0, $y65=0, $c65=0, $x66=0, $y66=0, $c66=0, $x67=0, $y67=0, $c67=0 &@CRLF& _
   "", $x68=0, $y68=0, $c68=0, $x69=0, $y69=0, $c69=0, $x70=0, $y70=0, $c70=0, $x71=0, $y71=0, $c71=0 &@CRLF& _
   "", $x72=0, $y72=0, $c72=0, $x73=0, $y73=0, $c73=0, $x74=0, $y74=0, $c74=0, $x75=0, $y75=0, $c75=0 &@CRLF& _
   "", $x76=0, $y76=0, $c76=0, $x77=0, $y77=0, $c77=0, $x78=0, $y78=0, $c78=0, $x79=0, $y79=0, $c79=0 &@CRLF& _
   "", $x80=0, $y80=0, $c80=0, $x81=0, $y81=0, $c81=0, $x82=0, $y82=0, $c82=0, $x83=0, $y83=0, $c83=0 &@CRLF& _
   "", $x84=0, $y84=0, $c84=0, $x85=0, $y85=0, $c85=0, $x86=0, $y86=0, $c86=0, $x87=0, $y87=0, $c87=0 &@CRLF& _
   "", $x88=0, $y88=0, $c88=0, $x89=0, $y89=0, $c89=0, $x90=0, $y90=0, $c90=0, $x91=0, $y91=0, $c91=0 &@CRLF& _
   "", $x92=0, $y92=0, $c92=0, $x93=0, $y93=0, $c93=0, $x94=0, $y94=0, $c94=0, $x95=0, $y95=0, $c95=0 &@CRLF& _
   "", $x96=0, $y96=0, $c96=0, $x97=0, $y97=0, $c97=0, $x98=0, $y98=0, $c98=0, $x99=0, $y99=0, $c99=0 &@CRLF& _
   "" )
;MsgBox("","check","01 = "&$r0&"  02 = "&$r0,0)
	Local $aPixelColor[100], $g_color[100]
    ; thiet lap thong so ham
    $iWidth = $gx0
    $iHeight = $gy0
	Local $g_x[100] = [$x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10, $x11, $x12, $x13, $x14, $x15, $x16, $x17, $x18, $x19 &@CRLF& _
				    "",$x20, $x21, $x22, $x23, $x24, $x25, $x26, $x27, $x28, $x29, $x30, $x31, $x32, $x33, $x34, $x35, $x36, $x37, $x38, $x39 &@CRLF& _
					"",$x40, $x41, $x42, $x43, $x44, $x45, $x46, $x47, $x48, $x49, $x50, $x51, $x52, $x53, $x54, $x55, $x56, $x57, $x58, $x59 &@CRLF& _
					"",$x60, $x61, $x62, $x63, $x64, $x65, $x66, $x67, $x68, $x69, $x70, $x71, $x72, $x73, $x74, $x75, $x76, $x77, $x78, $x79 &@CRLF& _
					"",$x80, $x81, $x82, $x83, $x84, $x85, $x86, $x87, $x88, $x89, $x90, $x91, $x92, $x93, $x94, $x95, $x96, $x97, $x98, $x99 &@CRLF& _
                ""]

    Local $g_y[100] = [$y0, $y1, $y2, $y3, $y4, $y5, $y6, $y7, $y8, $y9, $y10, $y11, $y12, $y13, $y14, $y15, $y16, $y17, $y18, $y19 &@CRLF& _
				    "",$y20, $y21, $y22, $y23, $y24, $y25, $y26, $y27, $y28, $y29, $y30, $y31, $y32, $y33, $y34, $y35, $y36, $y37, $y38, $y39 &@CRLF& _
					"",$y40, $y41, $y42, $y43, $y44, $y45, $y46, $y47, $y48, $y49, $y50, $y51, $y52, $y53, $y54, $y55, $y56, $y57, $y58, $y59 &@CRLF& _
					"",$y60, $y61, $y62, $y63, $y64, $y65, $y66, $y67, $y68, $y69, $y70, $y71, $y72, $y73, $y74, $y75, $y76, $y77, $y78, $y79 &@CRLF& _
					"",$y80, $y81, $y82, $y83, $y84, $y85, $y86, $y87, $y88, $y89, $y90, $y91, $y92, $y93, $y94, $y95, $y96, $y97, $y98, $y99 &@CRLF& _
                ""]

    Local $g_c[100] = [$c0, $c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8, $c9, $c10, $c11, $c12, $c13, $c14, $c15, $c16, $c17, $c18, $c19 &@CRLF& _
				    "",$c20, $c21, $c22, $c23, $c24, $c25, $c26, $c27, $c28, $c29, $c30, $c31, $c32, $c33, $c34, $c35, $c36, $c37, $c38, $c39 &@CRLF& _
					"",$c40, $c41, $c42, $c43, $c44, $c45, $c46, $c47, $c48, $c49, $c50, $c51, $c52, $c53, $c54, $c55, $c56, $c57, $c58, $c59 &@CRLF& _
					"",$c60, $c61, $c62, $c63, $c64, $c65, $c66, $c67, $c68, $c69, $c70, $c71, $c72, $c73, $c74, $c75, $c76, $c77, $c78, $c79 &@CRLF& _
					"",$c80, $c81, $c82, $c83, $c84, $c85, $c86, $c87, $c88, $c89, $c90, $c91, $c92, $c93, $c94, $c95, $c96, $c97, $c98, $c99 &@CRLF& _
                ""]

	For $lp_color = 0 to 99
    If $g_x[$lp_color] <> 0 and $g_x[$lp_color] <> 0 Then $lp_max = $lp_color
    Next

    _GDIPlus_Startup()

    Local $hDDC = _WinAPI_GetDC($WinHandle)
    Local $hCDC = _WinAPI_CreateCompatibleDC($hDDC)

    $hBMP = _WinCapture($WinHandle,$nFlags) ; toc do chap hon bat dc screen an pixel 2
    $BMP = _GDIPlus_BitmapCreateFromHBITMAP($hBMP)
    _WinAPI_DeleteObject($hBMP)
    ; bit map lockbits nhanh hon
    Local $tBitmapData = _GDIPlus_BitmapLockBits($BMP, 0, 0, $iWidth, $iHeight, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB) ;locks a portion of a bitmap for reading and writing. More infor at http://msdn.microsoft.com/en-us/library/windows/desktop/ms536298(v=vs.85).aspx
    Local $iScan0 = DllStructGetData($tBitmapData, "Scan0") ;get scan0 (pixel data) from locked bitmap
    Local $iSearchPixel = Int(0xFF000080), $iReplaceColor = 0x00000000 ;color format 0xAARRGGBB
    Local $tPixel = DllStructCreate("int[" & $iWidth * $iHeight & "];", $iScan0)
    Local $iPixel, $iRowOffset


    If $check0 = 0 Then ; get color pixel

	For $lp_check01 = 0 to $lp_max ; kiem tra 1 to 99
    $iRowOffset = $g_y[$lp_check01] * $gx0+1 ; $iRowOffset = $iY * $iWidth + 1
    $aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]),6) ;get pixel color
    Next

    ElseIf $check0 = 1 Then ; kiem tra mau co trung nhau PixelSearch

	For $lp_check01 = 0 to $lp_max ; kiem tra 1 to 99
    $g_color[$lp_check01] = 0

	For $iY = -3 To 3
	   For $iX = -3 To 3

	$iRowOffset = ($g_y[$lp_check01]+$iY) * $gx0+1 ; $iRowOffset = $iY * $iWidth + 1
	$aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]+$iX),6) ;get pixel color
	;$aPixelColor[$lp_check01] = Hex(_GDIPlus_BitmapGetPixel($BMP, $g_x[$lp_check01]+$iX, $g_y[$lp_check01]+$iY), 6)
	If $g_color[$lp_check01] = 0 Then $g_color[$lp_check01] = _ColorSearch($g_x[$lp_check01], $g_y[$lp_check01], $g_c[$lp_check01], $aPixelColor[$lp_check01], $r0)
	If $g_color[$lp_check01] = 1 Then ExitLoop
	;If $lp_check01 = 39 Then MsgBox("","check","xy = "&$g_x[$lp_check01]+$iX&","&$g_y[$lp_check01]+$iY&"  aPixelColor = "&$aPixelColor[$lp_check01]&"  $g_color = "&$g_color[$lp_check01],0)
	Next ; end X
	If $g_color[$lp_check01] = 1 Then ExitLoop
    Next ; end Y


   Next ; end kiem tra color

   EndIf ; end get color pixel

; end PixelSearch
    _GDIPlus_BitmapUnlockBits($BMP, $tBitmapData) ;unlocks a portion of a bitmap that was locked by _GDIPlus_BitmapLockBits
    _WinAPI_ReleaseDC($WinHandle, $hDDC)
    _WinAPI_DeleteDC($hCDC)
    _WinAPI_DeleteObject($hBMP)
    _GDIPlus_ImageDispose($BMP)

    If $check0=0 Then Return $aPixelColor
    If $check0=1 Then Return $g_color
 EndFunc   ;==>_GetColor




Func _ColorSearch($x0, $y0, $c_color0, $g_color0, $r0)

   $color_on = 0
    $iR0 = Dec(StringMid($c_color0, 1, 2))
    $iG0 = Dec(StringMid($c_color0, 3, 2))
    $iB0 = Dec(StringMid($c_color0, 5, 2))

    $iR1 = Dec(StringMid($g_color0, 1, 2))
    $iG1 = Dec(StringMid($g_color0, 3, 2))
    $iB1 = Dec(StringMid($g_color0, 5, 2))


If $iR0 > $iR1-$r0 and $iR0 < $iR1+$r0 Then
   If $iG0 > $iG1-$r0 and $iG0 < $iG1+$r0 Then
	  If $iB0 > $iB1-$r0 and $iB0 < $iB1+$r0 Then
		 If $x0 <> 0 and $y0 <> 0 Then $color_on = 1
    EndIf
  EndIf
EndIf
   ;MsgBox("","check","$c_color0 = "&$c_color0&"  $g_color0 = "&$g_color0&"  $color_on = "&$color_on&"  $r0 = "&$r0 &@CRLF& _
   ;"$c_color0 = "&$c_color0&"   $iR0 = "& $iR0&"  $iG0 = "&$iG0&"  $iB0 = "&$iB0 &@CRLF& _
   ;"$g_color0 = "&$g_color0&"   $iR1 = "& $iR1&"  $iG1 = "&$iG1&"  $iB1 = "&$iB1 &@CRLF& _
   ;"",0)
   Return $color_on

   EndFunc

   Func _WinCapture($hWnd,$nFlags, $iWidth = -1, $iHeight = -1)

    Local $iH, $iW, $hDDC, $hCDC, $hBMP

    If $iWidth = -1 Then $iWidth = _WinAPI_GetWindowWidth($hWnd)
    If $iHeight = -1 Then $iHeight = _WinAPI_GetWindowHeight($hWnd)

    $hDDC = _WinAPI_GetDC($hWnd)
    $hCDC = _WinAPI_CreateCompatibleDC($hDDC)
    $hBMP = _WinAPI_CreateCompatibleBitmap($hDDC, $iWidth, $iHeight)
    _WinAPI_SelectObject($hCDC, $hBMP)

    DllCall("User32.dll", "int", "PrintWindow", "hwnd", $hWnd, "hwnd", $hCDC, "int", $nFlags)


    _WinAPI_ReleaseDC($hWnd, $hDDC)
    _WinAPI_DeleteDC($hCDC)

    Return $hBMP

EndFunc  ;==>_WinCapture

Func _ColorSearchAll($color0,$lp0,$lp1,$max0)
	    $n_color0 = 0
        $g_color0 = 0
		For $lp0 = $lp0 to $lp1
        If $color0[$lp0] = 1 Then
		$n_color0 += 1
        EndIf
	    ;MsgBox(0, "Details", "$color0[$lp01]="&$color0[$lp0]&"  $n_color0=" &$n_color0&"  $g_color0=" &$g_color0)
        If $n_color0 >= $max0 Then
	    $g_color0 = 1
		$lp0 = 99
		EndIf
	 Next
	 Return $g_color0
  EndFunc









  ; Super pixel color ----------------------------------------------------------------------------------------------
 ;  $stream = _GetColorEX01new($gamex01, $gamey01, $control01,3) ; print image
 ;	$g_color01 = _GetColorEX01check($stream[0], $stream[1], $stream[2], 1, 16, 28, 76, "D5739C" &@CRLF& _ ; $iWidth, $iHeight, $tPixel 0 fix 0 1
	;    "", 28, 59, "D5729A", 417, 68, "FF2222", 21, 424, "FF2222", 21, 424, "FF2222" ) ; 1 mon phai, 2 x mac do, 3 nhan quest, 4 auto vang
    ; _GetColorEX01remove($stream[3], $stream[4], $stream[5], $stream[6], $stream[7], $stream[8]) ; remove print image


Func _GetColorEX01new($iWidth, $iHeight, $WinHandle,$nFlags=3,$x0=0,$y0=0)

    ; thiet lap thong so ham

    _GDIPlus_Startup() ; Lay image game vao memory

    Local $hDDC = _WinAPI_GetDC($WinHandle)
    Local $hCDC = _WinAPI_CreateCompatibleDC($hDDC)

    Local $hBMP = _WinCapture01($WinHandle,$nFlags) ; toc do chap hon bat dc screen an pixel 2
    Local $BMP = _GDIPlus_BitmapCreateFromHBITMAP($hBMP)

    ; bit map lockbits nhanh hon
    Local $tBitmapData = _GDIPlus_BitmapLockBits($BMP, $x0, $y0, $iWidth, $iHeight, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB) ;locks a portion of a bitmap for reading and writing. More infor at http://msdn.microsoft.com/en-us/library/windows/desktop/ms536298(v=vs.85).aspx
    Local $iScan0 = DllStructGetData($tBitmapData, "Scan0") ;get scan0 (pixel data) from locked bitmap
    Local $iSearchPixel = Int(0xFF000080), $iReplaceColor = 0x00000000 ;color format 0xAARRGGBB
    Local $tPixel = DllStructCreate("int[" & $iWidth * $iHeight & "];", $iScan0)
    Local $iPixel, $iRowOffset ; end Lay image game vao memory



    Local $stream_var[9] = [$iWidth, $iHeight, $tPixel, $BMP, $tBitmapData, $WinHandle, $hDDC, $hCDC, $hBMP &@CRLF& _
                ""]

    _WinAPI_DeleteObject($hBMP)
;   Local $stream_var[0] = $iWidth
;	Local $stream_var[1] = $iHeight
;	Local $stream_var[2] = $tPixel
;	Local $stream_var[3] = $BMP
;	Local $stream_var[4] = $tBitmapData
;	Local $stream_var[5] = $WinHandle
;	Local $stream_var[6] = $hDDC
;	Local $stream_var[7] = $hCDC
;	Local $stream_var[8] = $hBMP
	Return $stream_var
    EndFunc

 Func _WinCapture01($hWnd,$nFlags, $iWidth = -1, $iHeight = -1)

    Local $iH, $iW, $hDDC, $hCDC, $hBMP

    If $iWidth = -1 Then $iWidth = _WinAPI_GetWindowWidth($hWnd)
    If $iHeight = -1 Then $iHeight = _WinAPI_GetWindowHeight($hWnd)

    $hDDC = _WinAPI_GetDC($hWnd)
    $hCDC = _WinAPI_CreateCompatibleDC($hDDC)
    $hBMP = _WinAPI_CreateCompatibleBitmap($hDDC, $iWidth, $iHeight)
    _WinAPI_SelectObject($hCDC, $hBMP)

    DllCall("User32.dll", "int", "PrintWindow", "hwnd", $hWnd, "hwnd", $hCDC, "int", $nFlags)


    _WinAPI_ReleaseDC($hWnd, $hDDC)
    _WinAPI_DeleteDC($hCDC)

    Return $hBMP

EndFunc  ;==>_WinCapture01

	 Func _GetColorEX01check($on0, $iWidth, $iHeight, $tPixel, $check0=0, $r0=10 &@CRLF& _
   "", $x0=0, $y0=0, $c0=0, $x1=0, $y1=0, $c1=0, $x2=0, $y2=0, $c2=0, $x3=0, $y3=0, $c3=0 &@CRLF& _
   "", $x4=0, $y4=0, $c4=0, $x5=0, $y5=0, $c5=0, $x6=0, $y6=0, $c6=0, $x7=0, $y7=0, $c7=0 &@CRLF& _
   "", $x8=0, $y8=0, $c8=0 &@CRLF& _
   "" )

	;MsgBox("","check","01 = "&$r0&"  02 = "&$r0,0)
	Local $aPixelColor[9], $g_color[9] ; lay x y color can check
    If $on0 = 1 Then ; on check color
	Local $g_x[9] = [$x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8 &@CRLF& _
                ""]

    Local $g_y[9] = [$y0, $y1, $y2, $y3, $y4, $y5, $y6, $y7, $y8 &@CRLF& _
                ""]

    Local $g_c[9] = [$c0, $c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8 &@CRLF& _
                ""]

	For $lp_color = 1 to 8 ; fix bo 0
    If $g_x[$lp_color] <> 0 and $g_x[$lp_color] <> 0 Then $lp_max = $lp_color
    Next ; end lay x y color can check



    If $check0 = 0 Then ; get color pixel
    $aPixelColor[0] = 0 ; fix bo 0
	For $lp_check01 = 1 to $lp_max ; kiem tra 1 to 11 fix bo 0
    $iRowOffset = $g_y[$lp_check01] * $iWidth+1 ; $iRowOffset = $iY * $iWidth + 1
    $aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]),6) ;get pixel color
    Next

    ElseIf $check0 = 1 Then ; kiem tra mau co trung nhau PixelSearch
    $g_color[0] = 0 ; fix bo 0
	For $lp_check01 = 1 to $lp_max ; kiem tra 1 to 99 fix bo 0
    $g_color[$lp_check01] = 0

	For $iY = -3 To 3
	   For $iX = -3 To 3

	$iRowOffset = ($g_y[$lp_check01]+$iY) * $iWidth+1 ; $iRowOffset = $iY * $iWidth + 1
	$aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]+$iX),6) ;get pixel color
	;$aPixelColor[$lp_check01] = Hex(_GDIPlus_BitmapGetPixel($BMP, $g_x[$lp_check01]+$iX, $g_y[$lp_check01]+$iY), 6)
	If $g_color[$lp_check01] = 0 Then $g_color[$lp_check01] = _ColorSearch01($g_x[$lp_check01], $g_y[$lp_check01], $g_c[$lp_check01], $aPixelColor[$lp_check01], $r0)
	;If $g_color[$lp_check01] = 0 Then $g_color[$lp_check01] = TestTrans01($g_c[$lp_check01], $aPixelColor[$lp_check01], $r0)



	If $g_color[$lp_check01] = 1 Then ExitLoop
	;If $lp_check01 = 39 Then MsgBox("","check","xy = "&$g_x[$lp_check01]+$iX&","&$g_y[$lp_check01]+$iY&"  aPixelColor = "&$aPixelColor[$lp_check01]&"  $g_color = "&$g_color[$lp_check01],0)
	Next ; end X
	If $g_color[$lp_check01] = 1 Then ExitLoop
    Next ; end Y


   Next ; end kiem tra color

   EndIf ; end get color pixel

    If $check0=1 Then
    $g_color[0] = 0
	For $lp_check01 = 1 to $lp_max ; kiem tra 1 to 99
    If $g_color[$lp_max] = 1 Then $g_color[0] = 1
    If $g_color[$lp_check01] = 0 Then
    $g_color[0] = 0
    ExitLoop
	EndIf
	Next

	EndIf
    EndIf ; end on check color
If $on0 = 0 Then ; on check color fix
For $lp_color = 0 to 8
$aPixelColor[$lp_color] = 0
$g_color[$lp_color] = 0
Next
EndIf ; end on check color fix
    If $check0=0 Then Return $aPixelColor
    If $check0=1 Then Return $g_color

    EndFunc




;   Local $stream_var[0] = $iWidth
;	Local $stream_var[1] = $iHeight
;	Local $stream_var[2] = $tPixel
;	Local $stream_var[3] = $BMP
;	Local $stream_var[4] = $tBitmapData
;	Local $stream_var[5] = $WinHandle
;	Local $stream_var[6] = $hDDC
;	Local $stream_var[7] = $hCDC
;	Local $stream_var[8] = $hBMP
    Func _GetColorEX01remove($BMP, $tBitmapData, $WinHandle,$hDDC, $hCDC, $hBMP)
	  ; MsgBox("","check","01 = "&$BMP&"  02 = "&$tBitmapData,0)
; end PixelSearch
    _GDIPlus_BitmapUnlockBits($BMP, $tBitmapData) ;unlocks a portion of a bitmap that was locked by _GDIPlus_BitmapLockBits all dell image
    _WinAPI_ReleaseDC($WinHandle, $hDDC)
    _WinAPI_DeleteDC($hCDC)
    _WinAPI_DeleteObject($hBMP)
    _GDIPlus_ImageDispose($BMP)

	 ;cleanup resources
    ; _GDIPlus_ImageDispose($hImage)
    ;_GDIPlus_GraphicsDispose($hContext)
    ;_GDIPlus_BitmapDispose($hBitmap)
    ; _GDIPlus_GraphicsDispose($hGraphic)
    _GDIPlus_Shutdown()

 EndFunc   ;==>_GetColor

Func _ColorSearch01($x0, $y0, $c_color0, $g_color0, $r0)

   $color_on = 0
    $iR0 = Dec(StringMid($c_color0, 1, 2))
    $iG0 = Dec(StringMid($c_color0, 3, 2))
    $iB0 = Dec(StringMid($c_color0, 5, 2))

    $iR1 = Dec(StringMid($g_color0, 1, 2))
    $iG1 = Dec(StringMid($g_color0, 3, 2))
    $iB1 = Dec(StringMid($g_color0, 5, 2))

If $iR0 > $iR1-$r0 and $iR0 < $iR1+$r0 Then
   If $iG0 > $iG1-$r0 and $iG0 < $iG1+$r0 Then
	  If $iB0 > $iB1-$r0 and $iB0 < $iB1+$r0 Then
		 If $x0 <> 0 and $y0 <> 0 Then $color_on = 1
    EndIf
  EndIf
EndIf
   ;MsgBox("","check","$c_color0 = "&$c_color0&"  $g_color0 = "&$g_color0&"  $color_on = "&$color_on&"  $r0 = "&$r0 &@CRLF& _
   ;"$c_color0 = "&$c_color0&"   $iR0 = "& $iR0&"  $iG0 = "&$iG0&"  $iB0 = "&$iB0 &@CRLF& _
   ;"$g_color0 = "&$g_color0&"   $iR1 = "& $iR1&"  $iG1 = "&$iG1&"  $iB1 = "&$iB1 &@CRLF& _
   ;"",0)
   Return $color_on

   EndFunc

Func TestTrans01($c_color0, $g_color0, $shade = 10)
 Local $iR01, $iG01, $iB01, $iR02, $iG02, $iB02, $iGrey
 Local $d_color0 = 0
 $c_color0 = "0x"&$c_color0 ; fix to hex
  $g_color0 = "0x"&$g_color0 ; fix to hex
   ; For $iY = 0 To $iHeight - 1
    ;    For $iX = 0 To $iWidth - 1
            ;$iColor = _GDIPlus_BitmapGetPixel($hBitmap, $iX, $iY) ;get current pixel color
            $iR01 = BitShift(BitAND($c_color0, 0xFF0000), 16) ;extract red color channel
            $iR02 = BitShift(BitAND($g_color0, 0xFF0000), 16) ;extract red color channel
			$d_color0 = abs($iR01-$iR02)
			;MsgBox(0, "$iR","$c_color0="&$c_color0&" $g_color0="&$g_color0&" $d_color0="&$d_color0)
			If $d_color0 > $shade Then
            Return 0
            EndIf

			$iG01 = BitShift(BitAND($c_color0, 0x00FF00), 8) ;extract green color channel
            $iG02 = BitShift(BitAND($g_color0, 0x00FF00), 8) ;extract green color channel
            $d_color0 = abs($iG01-$iG02)
			;MsgBox(0, "$iG","$c_color0="&$c_color0&" $g_color0="&$g_color0&" $d_color0="&$d_color0)
			If $d_color0 > $shade Then
            Return 0
            EndIf

			$iB01 = BitAND($c_color0, 0x0000FF) ;;extract blue color channel
            $iB02 = BitAND($g_color0, 0x0000FF) ;;extract blue color channel
			$d_color0 = abs($iB01-$iB02)
			;MsgBox(0, "$iB","$c_color0="&$c_color0&" $g_color0="&$g_color0&" $d_color0="&$d_color0)
			If $d_color0 > $shade Then
            Return 0
            EndIf

            Return 1
			;$iGrey = Hex(Int(($iR + $iG + $iB) / 3), 2) ;convert pixels to average greyscale color format
            ;_GDIPlus_BitmapSetPixel($hBitmap, $iX, $iY, "0xFF" & $iGrey & $iGrey & $iGrey) ;set greyscaled pixel
     ;   Next
   ; Next
EndFunc













;Local $stream = _WinCapture04($hWindow,3,$gamex01,$gamey01,1) ; chay only show gui image
Func _WinCapture05($hWnd,$nFlags, $iWidth = -1, $iHeight = -1, $del_hBMP=0, $x0=0, $y0=0, $g_x0=0, $g_y0=0 ) ; chay only show gui image
      _GDIPlus_Startup() ; Lay image game vao memory
    Local $iH, $iW, $hDDC, $hCDC, $hBMP

    If $iWidth = -1 Then $iWidth = _WinAPI_GetWindowWidth($hWnd)
    If $iHeight = -1 Then $iHeight = _WinAPI_GetWindowHeight($hWnd)

    $hDDC = _WinAPI_GetDC($hWnd)
    $hCDC = _WinAPI_CreateCompatibleDC($hDDC)
    $hBMP = _WinAPI_CreateCompatibleBitmap($hDDC, $iWidth, $iHeight)
    _WinAPI_SelectObject($hCDC, $hBMP)
    If $del_hBMP = 1 Then _WinAPI_DeleteObject($hBMP)
    DllCall("User32.dll", "int", "PrintWindow", "hwnd", $hWnd, "hwnd", $hCDC, "int", $nFlags)

	; bit map lockbits nhanh hon

    Local $BMP = _GDIPlus_BitmapCreateFromHBITMAP($hBMP)

    Local $tBitmapData = _GDIPlus_BitmapLockBits($BMP, $x0, $y0, $iWidth, $iHeight, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB) ;locks a portion of a bitmap for reading and writing. More infor at http://msdn.microsoft.com/en-us/library/windows/desktop/ms536298(v=vs.85).aspx
    Local $iScan0 = DllStructGetData($tBitmapData, "Scan0") ;get scan0 (pixel data) from locked bitmap
    Local $iSearchPixel = Int(0xFF000080), $iReplaceColor = 0x00000000 ;color format 0xAARRGGBB
    Local $tPixel = DllStructCreate("int[" & $iWidth * $iHeight & "];", $iScan0)
    Local $iPixel, $iRowOffset ; end Lay image game vao memory
    ;_WinAPI_DeleteDC($hCDC)

	Local $stream_var[13] = [$hBMP, "", $tPixel, $BMP, $tBitmapData, $hWnd, $hDDC, $hCDC, $iWidth, $iHeight, $g_x0, $g_y0 &@CRLF& _
                ""]

	;$x01 = 555
	;$y01 = 394
	;$iRowOffset = $y01 * $iWidth+1 ; $iRowOffset = $iY * $iWidth + 1
    ;$acolor01 = Hex(DllStructGetData($stream_var[2], 1, $iRowOffset + $x01),6) ;get pixel color
    ;MsgBox("","check","01 = "&$acolor01&"  02 = "&$acolor01,0)

;   Local $stream_var[0] = $hBMP
;	Local $stream_var[1] = ""
;	Local $stream_var[2] = $tPixel
;	Local $stream_var[3] = $BMP
;	Local $stream_var[4] = $tBitmapData
;	Local $stream_var[5] = $WinHandle
;	Local $stream_var[6] = $hDDC
;	Local $stream_var[7] = $hCDC
;	Local $stream_var[8] = $iWidth
;	Local $stream_var[9] = $iHeight
;	Local $stream_var[10] = $g_x0
;	Local $stream_var[11] = $g_y0

	Return $stream_var
EndFunc  ;==>_WinCapture01



;$g_b_bag01 = _GetColorEX05check($g_b_bag01on, $stream[2], 1, 16, 2, 2, 10, 10, 10, 10 &@CRLF& _ ; $on0, $iWidth, $iHeight, $tPixel, $check0=0, $r0=10, $xs=3, $ys=3
;	    "", 708, 139, "E22D1C", 487, 422, "7FA13B", 544, 432, "F4F5AC", 711, 433, "D8B77E" ) ; 1 red X, 2 xanh Open, 3 e house, 4 RD nau nhat

;$g_b_team_setting01 = _GetColorEX05check($g_b_team_setting01on, $stream[2], 2, 16, 2, 2, 10, 10, 10, 10 &@CRLF& _ ; $on0, $iWidth, $iHeight, $tPixel, $check0=0, $r0=10, $xs=3, $ys=3
;	    "", 567, 152, "E22D1C", 330, 162, "873833", 188, 222, "0AA744", 436, 420, "779835","" &@CRLF& _ ; 1 red X, 2 T Team, 3 xanh o, 4 xanh confirm
 ;       "", 446, 429, "F4F5AC" ) ; 5 o confirm

;$g_b_adventure_current01 = _GetColorEX05check($g_b_adventure_current01on, $stream[2], 3, 16, 2, 2, 10, 10, 10, 10 &@CRLF& _ ; $on0, $iWidth, $iHeight, $tPixel, $check0=0, $r0=10, $xs=3, $ys=3
;	    "", 56, 483, "0C0705", 133, 483, "0C0705", 258, 483, "0C0705", 354, 483, "0C0705","" &@CRLF& _ ; 1 black1, 2 black2, 3 black3, 4 black4
;	    "", 56, 483, "FFF5DC", 133, 483, "FFF5DC", 258, 483, "FFF5DC", 354, 483, "FFF5DC" ) ; 5 white1, 6 white2, 7 white3, 8 white4

;$g_b_bag02 = _GetColorEX05check($g_b_bag01on, $stream[2], 4, 16, 100, 3, 5, 5, 5, 5 &@CRLF& _ ; $on0, $iWidth, $iHeight, $tPixel, $check0=0, $r0=10, $xs=3, $ys=3
;	    "", 34, 120, "FFC129", 36, 137, "6ADA86", 34, 154, "73D1FC", 34, 154, "73D1FC" ) ; 1 vang M, 2 xanh cay T, 3 xanh troi [, 4 RD nau nhat

;ToolTip("$g_b_bag01[0]="&$g_b_bag01[0]&" $g_b_bag01[1]="&$g_b_bag01[1]&" $g_b_bag01[2]="&$g_b_bag01[2]&" $g_b_bag01[3]="&$g_b_bag01[3]&" $g_b_bag01[4]="&$g_b_bag01[4]&@CRLF& _
;         "$g_b_team_setting01[0]="&$g_b_team_setting01[0]&" $g_b_team_setting01[1]="&$g_b_team_setting01[1]&" $g_b_team_setting01[2]="&$g_b_team_setting01[2]&" $g_b_team_setting01[3]="&$g_b_team_setting01[3]&" $g_b_team_setting01[4]="&$g_b_team_setting01[4]&@CRLF& _
;	     "$g_b_adventure_current01[0]="&$g_b_adventure_current01[0]&" $g_b_adventure_current01[1]="&$g_b_adventure_current01[1]&" $g_b_adventure_current01[2]="&$g_b_adventure_current01[2]&" $g_b_adventure_current01[3]="&$g_b_adventure_current01[3]&" $g_b_adventure_current01[4]="&$g_b_adventure_current01[4]&@CRLF& _
;		 "$g_b_adventure_current01[5]="&$g_b_adventure_current01[5]&" $g_b_adventure_current01[6]="&$g_b_adventure_current01[6]&" $g_b_adventure_current01[7]="&$g_b_adventure_current01[7]&" $g_b_adventure_current01[8]="&$g_b_adventure_current01[8]&@CRLF& _
;	     "$g_b_bag02[0]="&$g_b_bag02[0]&" $g_b_bag02[1]="&$g_b_bag02[1]&" $g_b_bag02[2]="&$g_b_bag02[2]&" $g_b_bag02[3]="&$g_b_bag02[3]&" $g_b_bag02[4]="&$g_b_bag02[4]&@CRLF& _
;		 "time = ",0,0)

	 Func _GetColorEX05check($on0, $tPixel, $g_x0, $g_y0 , $check0=0, $r0=10, $xs=3, $ys=3, $n1=10 &@CRLF& _ ; check = 0 = hex_color,  check = 1 = 0 > 1, check = 2 number 1+, check = 3 = 0 >  number 1+
   "", $n2=10, $n3=10, $n4=10, $x1=0, $y1=0, $c1=0, $x2=0, $y2=0, $c2=0, $x3=0, $y3=0, $c3=0 &@CRLF& _
   "", $x4=0, $y4=0, $c4=0, $fix1=0, $x5=0, $y5=0, $c5=0, $x6=0, $y6=0, $c6=0, $x7=0, $y7=0, $c7=0 &@CRLF& _
   "", $x8=0, $y8=0, $c8=0 &@CRLF& _
   "" )

	;MsgBox("","check","01 = "&$g_x0&"  02 = "&$r0,0)
	Local $aPixelColor[12], $g_color[12] ; lay x y color can check

	If $on0 = 1 Then ; on check color
	Local $g_x[12] = [$fix1, $x1+$g_x0, $x2+$g_x0, $x3+$g_x0, $x4+$g_x0, $x5+$g_x0, $x6+$g_x0, $x7+$g_x0, $x8+$g_x0, "" &@CRLF& _
                ""]

    Local $g_y[12] = [$fix1, $y1+$g_y0, $y2+$g_y0, $y3+$g_y0, $y4+$g_y0, $y5+$g_y0, $y6+$g_y0, $y7+$g_y0, $y8+$g_y0, "" &@CRLF& _
                ""]

    Local $g_c[12] = [$fix1, $c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8, "" &@CRLF& _
                ""]

	Local $g_n[12] = [$fix1, $n1, $n2, $n3, $n4, $n1, $n2, $n3, $n4, "" &@CRLF& _
                ""]

    Local $n_color[12] = [$fix1, $fix1, $fix1, $fix1, $fix1, $fix1, $fix1, $fix1, $fix1, "" &@CRLF& _
                ""]

	Local $n_color_max = 0
	Local $g_color_max = 0
	Local $x_down01 = 0
	Local $y_down01 = 0
	$g_color[0] = 0

	For $lp_color = 1 to 8 ; fix bo 0
	$g_color[$lp_color] = 0
    If $g_x[$lp_color] <> 0 and $g_x[$lp_color] <> 0 Then $lp_max = $lp_color
    Next ; end lay x y color can check

	If $check0 = 0 Then ; return hex(color)
    $xs=0
	$ys=0
    For $lp_check01 = 1 to $lp_max ; kiem tra 1 to 99 fix bo 0
    ;$g_color[$lp_check01] = 0
	For $iY = -$ys To $ys ; Y
	   $iRowOffset = ($g_y[$lp_check01]+$iY) * $stream[8]+1 ; $iRowOffset = $iY * $iWidth + 1
	   For $iX = -$xs To $xs ; X
	   $aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]+$iX),6) ;get pixel color
	   $g_color[$lp_check01] = $aPixelColor[$lp_check01]
	   Next ; end X
	Next ; end Y
    Next ; end kiem tra 1 to 99 fix bo 0

	EndIf

    If $check0 = 1 Then ; return check color 0 1
    For $lp_check01 = 1 to $lp_max ; kiem tra 1 to 99 fix bo 0
    ;$g_color[$lp_check01] = 0
	For $iY = -$ys To $ys ; Y
	   $iRowOffset = ($g_y[$lp_check01]+$iY) * $stream[8]+1 ; $iRowOffset = $iY * $iWidth + 1
	   For $iX = -$xs To $xs ; X
	   $aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]+$iX),6) ;get pixel color
	   $g_color[$lp_check01] = TestTrans05($g_c[$lp_check01], $aPixelColor[$lp_check01], $r0)
	   If $g_color[$lp_check01] = 1 Then ExitLoop ; exit X
	   Next ; end X
	   If $g_color[$lp_check01] = 1 Then ExitLoop ; exit Y
	Next ; end Y
    If $g_color[$lp_check01] = 1 Then $n_color_max += 1
	Next ; end kiem tra 1 to 99 fix bo 0
	EndIf

	If $check0 = 2 Then ; return check max color 0 1
    For $lp_check01 = 1 to $lp_max ; kiem tra 1 to 99 fix bo 0
    ;$g_color[$lp_check01] = 0
	$n_color[$lp_check01] = 0
	For $iY = -$ys To $ys ; Y
	   $iRowOffset = ($g_y[$lp_check01]+$iY) * $stream[8]+1 ; $iRowOffset = $iY * $iWidth + 1
	   For $iX = -$xs To $xs ; X
	   $aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]+$iX),6) ;get pixel color
	   $g_color[$lp_check01] = TestTrans05($g_c[$lp_check01], $aPixelColor[$lp_check01], $r0)
	   If $g_color[$lp_check01] = 1 Then $n_color[$lp_check01] += 1 ; number color+
	   Next ; end X
	Next ; end Y
    $g_color[$lp_check01] = $n_color[$lp_check01]
	If $g_color[$lp_check01] >= $g_n[$lp_check01] Then $g_color_max += 1
	Next ; end kiem tra 1 to 99 fix bo 0
	EndIf

    If $check0 = 3 Then ; return check all color 0 1
    For $lp_check01 = 1 to $lp_max ; kiem tra 1 to 99 fix bo 0
    ;$g_color[$lp_check01] = 0
	For $iY = -$ys To $ys ; Y
	   $iRowOffset = ($g_y[$lp_check01]+$iY) * $stream[8]+1 ; $iRowOffset = $iY * $iWidth + 1
	   For $iX = -$xs To $xs ; X
	   $aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]+$iX),6) ;get pixel color
	   $g_color[$lp_check01] = TestTrans05($g_c[$lp_check01], $aPixelColor[$lp_check01], $r0)
	   If $g_color[$lp_check01] = 1 Then ExitLoop ; exit X
	   Next ; end X
	   If $g_color[$lp_check01] = 1 Then ExitLoop ; exit Y
	Next ; end Y
    If $g_color[$lp_check01] = 1 Then $n_color_max += 1
	Next ; end kiem tra 1 to 99 fix bo 0
	EndIf


   	If $check0 = 4 Then ; return check max multi color Y > Y+ X + $xs Y + $ys



	For $iY = 0 To $ys Step 2; Y


	   For $lp_check01 = 1 to $lp_max ; kiem tra 1 to 99 fix bo 0
       If $lp_check01 = 1 Then $g_color[0] = 1
	   $n_color[$lp_check01] = 0
       $iRowOffset = ($g_y[$lp_check01]+$iY) * $stream[8]+1 ; $iRowOffset = $iY * $iWidth + 1
	   For $iX = 0 To $xs ; X
	   $aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]+$iX),6) ;get pixel color
	   $g_color[$lp_check01] = TestTrans05($g_c[$lp_check01], $aPixelColor[$lp_check01], $r0)
	   If $g_color[$lp_check01] = 1 Then $n_color[$lp_check01] += 1 ; number color+
		 ;  If $lp_check01 = $lp_check01 Then
         ;    MsgBox($MB_SYSTEMMODAL, "$lp_check0"&$lp_check01, "$g_color[$lp_check01] = "&$g_color[$lp_check01]&"   $n_color[$lp_check01] = "&$n_color[$lp_check01]&@CRLF& _
		 ; 	 "$g_c[$lp_check01] = "&$g_c[$lp_check01]&"   $aPixelColor[$lp_check01] = "&$aPixelColor[$lp_check01]&@CRLF& _
		;	 "$g_x[$lp_check01]+$iX = "&$g_x[$lp_check01]+$iX&"   $g_y[$lp_check01]+$iY = "&$g_y[$lp_check01]+$iY)
		;    EndIf
	   Next ; end X

	   If $g_color[$lp_check01] < $g_n[$lp_check01] Then $g_color[$lp_check01] = $n_color[$lp_check01]
         ; If $lp_check01 = $lp_check01 Then
          ;   MsgBox($MB_SYSTEMMODAL, "$lp_check0"&$lp_check01, "$g_color[$lp_check01] = "&$g_color[$lp_check01]&"   $n_color[$lp_check01] = "&$n_color[$lp_check01]&@CRLF& _
		  ;	 "$g_c[$lp_check01] = "&$g_c[$lp_check01]&"   $aPixelColor[$lp_check01] = "&$aPixelColor[$lp_check01]&@CRLF& _
		;	 "$g_x[$lp_check01]+$iX = "&$g_x[$lp_check01]+$iX&"   $g_y[$lp_check01]+$iY = "&$g_y[$lp_check01]+$iY)
		;    EndIf
	   If $lp_check01 = 1 Then
	   $x_down01 = $g_x[$lp_check01]+$iX
	   $y_down01 = $g_y[$lp_check01]+$iY
	   EndIf
	   If $g_color[$lp_check01] >= $g_n[$lp_check01] and $lp_check01 > $g_color_max Then
		  $g_color_max += 1
	   EndIf
	   If $g_color[$lp_check01] < $g_n[$lp_check01] Then $g_color[0] = 0
	   If $lp_max = $g_color_max Then ExitLoop ; exit kiem tra 1 to 99 fix bo 0

	   Next ; end kiem tra 1 to 99 fix bo 0
	   If $lp_max = $g_color_max Then ExitLoop ; exit Y

	Next ; end Y

	EndIf


    If $check0 = 5 Then ; return all check color tai xy 1+2+3+4
    For $lp_check01 = 1 to $lp_max ; kiem tra 1 to 99 fix bo 0
    ;$g_color[$lp_check01] = 0
	For $iY = -$ys To $ys ; Y
	   $iRowOffset = ($g_y[$lp_check01]+$iY) * $stream[8]+1 ; $iRowOffset = $iY * $iWidth + 1
	   For $iX = -$xs To $xs ; X

       $aPixelColor[$lp_check01] = Hex(DllStructGetData($tPixel, 1, $iRowOffset + $g_x[$lp_check01]+$iX),6) ;get pixel color
	   For $lp_color01 = 1 to $lp_max ; kiem tra 1 to 99 fix bo 0
	   $g_color[$lp_check01] = TestTrans05($g_c[$lp_color01], $aPixelColor[$lp_check01], $r0)
	   If $g_color[$lp_check01] = 1 Then
		  $g_color[$lp_check01] = $lp_color01
		  ExitLoop ; exit X
	   EndIf
	   Next ; end kiem tra 1 to 99 fix bo 0
	   If $g_color[$lp_check01] <> 0 Then ExitLoop ; exit X


	   Next ; end X
	   If $g_color[$lp_check01] <> 0 Then ExitLoop ; exit Y
	Next ; end Y
    If $g_color[$lp_check01] <> 0 Then $n_color_max += 1
	Next ; end kiem tra 1 to 99 fix bo 0
	EndIf









    If $check0 = 1 Then ; check all color = 1
    If $lp_max = $n_color_max Then $g_color[0] = 1

	ElseIf $check0 = 2 Then ; check all number color = 1
    If $lp_max = $g_color_max Then $g_color[0] = 1

    ElseIf $check0 = 3 Then ; check all color = 1
	$g_color[0] = $n_color_max

	ElseIf $check0 = 4 Then ; check all number color = 1
	If $g_color[0] = 1 Then
	   $g_color[9] = $x_down01
	   $g_color[10] = $y_down01
	ElseIf $g_color[0] = 0 Then
	   $g_color[9] = 0
	   $g_color[10] = 0

	EndIf

	ElseIf $check0 = 5 Then ; check all color = 1
    If $lp_max = $n_color_max Then $g_color[0] = 1

	EndIf ; end check all color = 1

;$delay_pause01 = 0 ; pause check color
;$delay_pause02 = 0 ; pause check color
Sleep($delay_pause01)

    EndIf ; end on check color

If $on0 = 0 Then ; on check color fix
For $lp_color = 0 to 8
$g_color[$lp_color] = 0
Next
EndIf ; end on check color fix

  Return $g_color
    EndFunc

;_GetColorEX05remove($stream[3], $stream[4], $stream[5], $stream[6], $stream[7], $stream[0]) ; remove print image --------------------------
    Func _GetColorEX05remove($BMP, $tBitmapData, $WinHandle,$hDDC, $hCDC, $hBMP)

    _GDIPlus_BitmapUnlockBits($BMP, $tBitmapData) ;unlocks a portion of a bitmap that was locked by _GDIPlus_BitmapLockBits all dell image
    _WinAPI_ReleaseDC($WinHandle, $hDDC)
    _WinAPI_DeleteDC($hCDC)
    _WinAPI_DeleteObject($hBMP)
    _GDIPlus_ImageDispose($BMP)

	 ;cleanup resources
    ; _GDIPlus_ImageDispose($hImage)
    ;_GDIPlus_GraphicsDispose($hContext)
    ;_GDIPlus_BitmapDispose($hBitmap)
    ; _GDIPlus_GraphicsDispose($hGraphic)
    _GDIPlus_Shutdown()

 EndFunc   ;==>_GetColor

Func TestTrans05($c_color0, $g_color0, $shade = 10)
 Local $iR01, $iG01, $iB01, $iR02, $iG02, $iB02, $iGrey
 Local $d_color0 = 0
 $c_color0 = "0x"&$c_color0 ; fix to hex
  $g_color0 = "0x"&$g_color0 ; fix to hex

            $iR01 = BitShift(BitAND($c_color0, 0xFF0000), 16) ;extract red color channel
            $iR02 = BitShift(BitAND($g_color0, 0xFF0000), 16) ;extract red color channel
			$d_color0 = abs($iR01-$iR02)
			;MsgBox(0, "$iR","$c_color0="&$c_color0&" $g_color0="&$g_color0&" $d_color0="&$d_color0)
			If $d_color0 >= $shade Then
            Return 0
            EndIf

			$iG01 = BitShift(BitAND($c_color0, 0x00FF00), 8) ;extract green color channel
            $iG02 = BitShift(BitAND($g_color0, 0x00FF00), 8) ;extract green color channel
            $d_color0 = abs($iG01-$iG02)
			;MsgBox(0, "$iG","$c_color0="&$c_color0&" $g_color0="&$g_color0&" $d_color0="&$d_color0)
			If $d_color0 >= $shade Then
            Return 0
            EndIf

			$iB01 = BitAND($c_color0, 0x0000FF) ;;extract blue color channel
            $iB02 = BitAND($g_color0, 0x0000FF) ;;extract blue color channel
			$d_color0 = abs($iB01-$iB02)
			;MsgBox(0, "$iB","$c_color0="&$c_color0&" $g_color0="&$g_color0&" $d_color0="&$d_color0)
			If $d_color0 >= $shade Then
            Return 0
            EndIf

            Return 1

EndFunc



; end Super pixel color ----------------------------------------------------------------------------------------------