#include <GUIConstants.au3>
#include <StaticConstants.au3>
#include <Array.au3>

Const $worldWidth = 16
Const $worldHeight = 16

Const $tileWidth = 32
Const $tileHeight = 32

Const $cellSpacing = 2
Const $boardMargin = 40

Const $startHeight = 54
Const $startWeight = 120

;Array to store all label handles
Dim $gui_label[$worldHeight][$worldWidth][2]
Dim $boardArray[$worldHeight][$worldWidth] = [ _
        [ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
        [ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
        [ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,2 ,0 ,0 ], _
        [ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,3 ,3 ,3 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,3 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,3 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,3 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 1, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
		[ 0, 0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ], _
        []]

;_ArrayDisplay($boardArray, "$avArray BEFORE _ArraySort()")






;Create GUI window
GUICreate("BMI", (($tileWidth+$cellSpacing)*$worldWidth) + ($boardMargin*2), (($tileHeight+$cellSpacing)*$worldHeight) + ($boardMargin*2))  ; will create a dialog box that when displayed is centered

$currentHeight = $startHeight
For $Y = 0 to $worldHeight - 1

    ;Reset current weight at beginning of each row
    $currentWeight = $startWeight

    For $X = 0 to $worldWidth - 1

        ;Draw weight headings
        If $Y = 0 Then
            GuiCtrlCreateLabel($currentWeight,($X*($tileWidth +$cellSpacing)) + $boardMargin, $boardMargin - 15, $tileWidth, $tileWidth, $SS_CENTER)
        EndIf

        ;Draw height headings
        If $X = 0 Then
            GuiCtrlCreateLabel(InchesToFeet($currentHeight),7, ($Y*($tileHeight+$cellSpacing)) + $boardMargin, 30, $tileWidth, $SS_RIGHT)
        EndIf

        ;Get BMI
        $currentBMI = BMI($currentHeight, $currentWeight)

        ;Draw label
        $gui_label[$Y][$X][0] = GuiCtrlCreateLabel($X&","&$Y,($X*($tileWidth +$cellSpacing)) + $boardMargin, ($Y*($tileHeight+$cellSpacing)) + $boardMargin, $tileWidth, $tileHeight, $SS_CENTER )

        Switch $boardArray[$Y][$X]
            Case 1
                GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0x97c05b);Green
            Case 2
                GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0xf37042);Red
            Case 3
                GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0xf5e77d);Yellow
            Case 4
			    GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0xa9d7d9);Blue
			Case Else
			GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0xFFFFFF);white

        EndSwitch



        ;Increment 10 pounds at a time
        $currentWeight += 10
    Next

    ;Increment 2 inches at a time
    $currentHeight += 2
Next

Local $X = 4 , $Y = 4
$boardArray[$X][$Y] = 2

        Switch $boardArray[$Y][$X]
            Case 1
                GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0x97c05b);Green
            Case 2
                GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0xf37042);Red
            Case 3
                GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0xf5e77d);Yellow
            Case 4
			    GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0xa9d7d9);Blue
			Case Else
			GUICtrlSetBkColor ($gui_label[$Y][$X][0], 0xFFFFFF);white

        EndSwitch


GUISetState (@SW_SHOW)       ; will display an empty dialog box

; Run the GUI until the dialog is closed
While 1
    $msg = GUIGetMsg()

    If $msg = $GUI_EVENT_CLOSE Then ExitLoop
Wend

;Return BMI given height (in inches) and weight (in pounds)
Func BMI($height, $weight)
    Return Floor(($weight * 703) / ($height^2))
EndFunc

;Convert inches to feet/inches string
Func InchesToFeet($inches)
    $feet = Int($inches / 12)
    $remain = Mod($inches, 12)
    Return $feet & "' " & $remain & '"'
EndFunc