;==============================
; Author: Toady
; Site: www.itoady.com
; Updated: May 21, 2008
; AutoIt Ver: 3.2.12.0
;
; A * Searching Alorithm
; Artificial Intelligence
; Robot path finding
;==============================

#include <Array.au3>
#include <MsgBoxConstants.au3>
#include <Misc.au3>
#include <StaticConstants.au3>
#include <GuiConstants.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#Include <process.au3>
#Include <File.au3>
#include<Constants.au3>
#include <GDIPlus.au3>

;==================== START OF MAIN =================
; Example GUI by, Hallman and Toady
; Event ID:	the ID of the control sending the message
; $GUI_EVENT_NONE (0):	No event
; $GUI_EVENT_CLOSE:	dialog box being closed (either by defined button or system menu).
; $GUI_EVENT_MINIMIZE:	dialog box minimized with Windows title bar button.
; $GUI_EVENT_RESTORE:	dialog box restored by click on task bar icon.
; $GUI_EVENT_MAXIMIZE:	dialog box maximized with Windows title bar button.
; $GUI_EVENT_MOUSEMOVE:	the mouse cursor has moved.
; $GUI_EVENT_PRIMARYDOWN:	the primary mouse button was pressed.
; $GUI_EVENT_PRIMARYUP:	the primary mouse button was released.
; $GUI_EVENT_SECONDARYDOWN:	the secondary mouse button was pressed.
; $GUI_EVENT_SECONDARYUP:	the secondary mouse button was released.
; $GUI_EVENT_RESIZED:	dialog box has been resized.
; $GUI_EVENT_DROPPED:	End of a Drag&Drop action @GUI_DragId, @GUI_DragFile and @GUI_DropId will be used to retrieve the ID's/file corresponding to the involve control.

Global $first_label = 0
Global $last_label = 0

Global Const $rows = 36
Global Const $cols = 36

Global $estimate
Global $closedList_data
Global $closedList_Str = "_"
Global $openList_Str = "_"
Global $start_handel[3]
Global $end_handel[3]
Global $barrier[] = [-1]

Global $heuristic = 1
Global $allow_diagonals_Boolean = 1 ; 1 = chay 8 0 = chay 4

Global $worldWidth = 96
Global $worldHeight = 64
Global $startx01, $starty01, $start_red = 0
Global $goalx01, $goaly01, $goal_green = 0
Global $listnindex, $target_found = 0

Dim $open[$worldWidth * $worldHeight + 1] ;why one-dimensional? so that you can convert it to a struct^^
Dim $close[$worldWidth * $worldHeight + 1][3] ;list of the best candidates

Dim $path01[0] ;start from goal node

$w = 1024 ; 1024 197
$h = 768 ; 768 197
$distance = 1 ; khoang cach tiled map

$tileWidth = ($w/$worldWidth)-$distance
$tileHeight = ($h/$worldHeight)-$distance

Opt("MouseCoordMode", 2) ;1=absolute, 0=relative, 2=client

$hgui = GUICreate("a-star", $w, $h+$worldHeight+50, -1, -1, -1, $WS_EX_LAYERED)
;WinSetTrans ( $hGUI ,  "" ,  255)
    GUISetState(@SW_SHOW)
    Sleep(100)

GUISetBkColor(0xABCDEF)
;_WinAPI_SetLayeredWindowAttributes($hgui, 0x010101)
_WinAPI_SetLayeredWindowAttributes($hgui, 0xABCDEF)

Global $idCheckbox01_01 = GUICtrlCreateCheckbox("Start s", 10, $h+(17*1), 70, 20)
Global $idCheckbox01_02 = GUICtrlCreateCheckbox("Target t", 80, $h+(17*1), 70, 20)
Global $idCheckbox01_03 = GUICtrlCreateCheckbox("wall x", 150, $h+(17*1), 70, 20)
Global $idCheckbox01_04 = GUICtrlCreateCheckbox('flat " "', 220, $h+(17*1), 70, 20)
Global $idCheckbox01_98 = GUICtrlCreateCheckbox("$allow_diagonals", 120, $h+(17*2), 90, 20)
Global $idCheckbox01_99 = GUICtrlCreateButton("Pathfind A*", 10, $h+(17*2), 90, 20)

GUICtrlSetState($idCheckbox01_98, $GUI_CHECKED)

$tiled_map01 = 0

$red = 0xFFFF0000
$green = 0xFF00FF00
$blue = 0xFF0000FF
$black = 0x00555555
$white = 0xFFF6F6F4
$gray = 0xFFAAAAAA

; Start GDIPlus
    _GDIPlus_Startup()
    $hGraphic = _GDIPlus_GraphicsCreateFromHWND($hgui)

    ; Create solid brush
    $Brush_red = _GDIPlus_BrushCreateSolid()
    $Brush_green = _GDIPlus_BrushCreateSolid()
    $Brush_blue = _GDIPlus_BrushCreateSolid()
    $Brush_black = _GDIPlus_BrushCreateSolid()
	$Brush_white = _GDIPlus_BrushCreateSolid()
    $Brush_gray = _GDIPlus_BrushCreateSolid()

    ; Get solid brush color
    ;$iClr1 = _GDIPlus_BrushGetSolidColor($hBrush1)

    ; Draw some graphics with the original brush color
    ;_GDIPlus_GraphicsFillEllipse($hGraphic, 25, 25, 100, 100, $hBrush1)

    ; Set new brush color (0xFFFF0000 = Red)
    _GDIPlus_BrushSetSolidColor($Brush_red, $red)
    _GDIPlus_BrushSetSolidColor($Brush_green, $green)
	_GDIPlus_BrushSetSolidColor($Brush_blue, $blue)
	_GDIPlus_BrushSetSolidColor($Brush_black, $black)
	_GDIPlus_BrushSetSolidColor($Brush_white, $white)
	_GDIPlus_BrushSetSolidColor($Brush_gray, $gray)
    ; Get new solid brush color
    ;$iClr2 = _GDIPlus_BrushGetSolidColor($hBrush1)




;============ * How to use this code * ============
; Below is the A * Searching algorithm and its
; required functions to work.
; This is coded to work with 2D spaces only.
; Everything below is all you need to get started.
Dim $data[$worldWidth][$worldHeight]
; 1. Initialize a 2D array
Dim     $data_map[$worldWidth][$worldHeight] = [["x","x","x","x","x","x","x","x","x","x"], _
                        ["x","s","0","0","0","0","0","0","0","x"], _
                        ["x","0","0","0","0","0","0","0","0","x"], _
                        ["x","0","0","0","0","0","0","0","0","x"], _
                        ["x","0","0","0","0","0","0","0","0","x"], _
					    ["x","0","0","0","0","0","0","0","0","x"], _
					    ["x","0","0","0","0","0","0","0","g","x"], _
					    ["x","0","0","0","0","0","0","0","0","x"], _
					    ["x","0","0","0","0","0","0","0","0","x"], _
					    ["x","x","x","x","x","x","x","x","x","x"]]

$data = $data_map
draw_map01(0)




GUISetState()




While 1
$msg = GUIGetMsg()
Switch $msg

Case $GUI_EVENT_CLOSE
ExitLoop

Case $GUI_EVENT_RESTORE

draw_map01(1)



Case $idCheckbox01_99 ; a* start
If _IsChecked($idCheckbox01_98) = true Then
$allow_diagonals_Boolean = 1
ElseIf _IsChecked($idCheckbox01_98) = False Then
$allow_diagonals_Boolean = 0
EndIf

; reset map
Global $closedList_Str = "_"
Global $openList_Str = "_"

 Local $hTimer = TimerInit()

   $data = $data_map
; end reset map

 ;  MsgBox($MB_SYSTEMMODAL, "Title", "$startx01="&$startx01&" $starty01="&$starty01&" $goalx01="&$goalx01&" $goaly01="&$goaly01, 0)
;       NOTE: Array MUST have x's around entire paremeter
;       There must be a "s" and a "g". "0" means bot can walk here
; 2. Convert array into node objects
; _ArrayDisplay($data_map) ; will show the the full path
	   _CreateMap($data,$worldWidth,$worldHeight)
;	   _ArrayDisplay($data_map) ; will show the the full path
; 3. Calculate path
       Dim $path = _FindPath($data,$data[$startx01][$starty01],$data[$goalx01][$goaly01])
; 4. Thats all!
;       The variable $path contains an array of the path in "x,y" format
 ;      _ArrayDisplay($path) ; will show the the full path

$path01_Rows = UBound($path, $UBOUND_ROWS)

For $i = 0 To $path01_Rows - 1

	Local $node_coord = StringSplit($path[$i], ",")
	Local $y = $node_coord[1] ; dao $x $y
	Local $x = $node_coord[2] ; thanh $y $x

_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_blue)
Sleep(25)
_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_gray)

If $i = $path01_Rows-1 Then ;starting point > goal
			If $start_red  <> 0 Then
            _GDIPlus_GraphicsFillRect($hGraphic, $startx01 * ($tileWidth + $distance) + $distance, $starty01 * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_gray)
			$data_map[$startx01][$starty01] = "0"
			EndIf

			If $goal_green  <> 0 Then
            _GDIPlus_GraphicsFillRect($hGraphic, $goalx01 * ($tileWidth + $distance) + $distance, $goaly01 * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_gray)
			$data_map[$goalx01][$goaly01] = "0"
			EndIf

			$goalx01 = $startx01
			$goaly01 = $starty01
            $data_map[$startx01][$starty01] = "g"
			$goal_green = $y * $worldWidth + $x
_GDIPlus_GraphicsFillRect($hGraphic, $goalx01 * ($tileWidth + $distance) + $distance, $goaly01 * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_green)

			$startx01 = $x
			$starty01 = $y
            $data_map[$x][$y] = "s"
			$start_red = $y * $worldWidth + $x
_GDIPlus_GraphicsFillRect($hGraphic, $startx01 * ($tileWidth + $distance) + $distance, $starty01 * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_red)

EndIf ; end starting point > goal

Next


Local $iDiff = TimerDiff($hTimer) ; time in seconds
ConsoleWrite("$iDiff"&" $iDiff="&$iDiff&"  $xxyy="&$xx&","&$yy& @CR)

Case $GUI_EVENT_PRIMARYDOWN ; $open[0] To $open[$worldWidth * $worldHeight - 1]
 While _IsPressed('01') = True ; press left mouse
Local $aPos = MouseGetPos()
$xx = Int($aPos[0]/($tileWidth+$distance))
$yy = Int($aPos[1]/($tileHeight+$distance))

If $xx > 0 And $yy > 0 And $xx < $worldWidth -1 And $yy < $worldHeight - 1 Then ; within the border area
ConsoleWrite("Primary down"&" MouseGetPos="&$aPos[0]&","&$aPos[1]&"  $xxyy="&$xx&","&$yy& @CR)

			If _IsChecked($idCheckbox01_01) Then
			If $start_red  <> 0 Then
			$data_map[$startx01][$starty01] = "0"
			_GDIPlus_GraphicsFillRect($hGraphic, $startx01 * ($tileWidth + $distance) + $distance, $starty01 * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_gray)
			EndIf
			$startx01 = $xx
			$starty01 = $yy
            $data_map[$startx01][$starty01] = "s"
			$start_red = ($yy - 0) * $worldWidth + ($xx - 0)
			_GDIPlus_GraphicsFillRect($hGraphic, $startx01 * ($tileWidth + $distance) + $distance, $starty01 * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_red)

			;_ArrayDisplay($data_map) ; will show the the full path
			;GUICtrlSetState($idCheckbox01_01, $GUI_UNCHECKED)
			 GUICtrlSetState($idCheckbox01_02, $GUI_UNCHECKED)
			  GUICtrlSetState($idCheckbox01_03, $GUI_UNCHECKED)
			   GUICtrlSetState($idCheckbox01_04, $GUI_UNCHECKED)
			EndIf ; end checkbox MEmu01


			If _IsChecked($idCheckbox01_02) Then
            If $goal_green <> 0 Then
            $data_map[$goalx01][$goaly01] = "0"
			_GDIPlus_GraphicsFillRect($hGraphic, $goalx01 * ($tileWidth + $distance) + $distance, $goaly01 * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_gray)
			EndIf
			$goalx01 = $xx
            $goaly01 = $yy
			$data_map[$goalx01][$goaly01] = "g"
			$goal_green = ($yy - 0) * $worldWidth + ($xx - 0)
			_GDIPlus_GraphicsFillRect($hGraphic, $goalx01 * ($tileWidth + $distance) + $distance, $goaly01 * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_green)
			;_ArrayDisplay($data_map) ; will show the the full path

			GUICtrlSetState($idCheckbox01_01, $GUI_UNCHECKED)
			; GUICtrlSetState($idCheckbox01_02, $GUI_UNCHECKED)
			  GUICtrlSetState($idCheckbox01_03, $GUI_UNCHECKED)
			   GUICtrlSetState($idCheckbox01_04, $GUI_UNCHECKED)
			EndIf ; end checkbox MEmu01


			If _IsChecked($idCheckbox01_03) Then
            $data_map[$xx][$yy] = "x"
			_GDIPlus_GraphicsFillRect($hGraphic, $xx * ($tileWidth + $distance) + $distance, $yy * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_black)

			GUICtrlSetState($idCheckbox01_01, $GUI_UNCHECKED)
			 GUICtrlSetState($idCheckbox01_02, $GUI_UNCHECKED)
			;  GUICtrlSetState($idCheckbox01_03, $GUI_UNCHECKED)
			   GUICtrlSetState($idCheckbox01_04, $GUI_UNCHECKED)
			EndIf ; end checkbox MEmu01


			If _IsChecked($idCheckbox01_04) Then
            $data_map[$xx][$yy] = "0"
			_GDIPlus_GraphicsFillRect($hGraphic, $xx * ($tileWidth + $distance) + $distance, $yy * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_gray)

			GUICtrlSetState($idCheckbox01_01, $GUI_UNCHECKED)
			 GUICtrlSetState($idCheckbox01_02, $GUI_UNCHECKED)
			  GUICtrlSetState($idCheckbox01_03, $GUI_UNCHECKED)
			;   GUICtrlSetState($idCheckbox01_04, $GUI_UNCHECKED)
			EndIf ; end checkbox MEmu01

EndIf ; end within the border area
Sleep(10)
WEnd ; end press left mouse


EndSwitch ; end $open[0] To $open[$worldWidth * $worldHeight - 1]
WEnd





Func draw_map01($tiled_map0 = 0)
For $y = 0 To $worldHeight - 1
For $x = 0 To $worldWidth - 1

If $tiled_map0 = 1 Then ; $tiled_map01 = 1
Switch $data_map[$x][$y]
Case "x"
$data_map[$x][$y] = "x"
_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_black)


Case "s"
$data_map[$x][$y] = "s"
$startx01 = $x
$starty01 = $y
$start_red = $y * $worldWidth + $x
_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_red)


Case "0"
$data_map[$x][$y] = "0"
_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_gray)


Case "g"
$data_map[$x][$y] = "g"
$goalx01 = $x
$goaly01 = $y
$goal_green = $y * $worldWidth + $x
_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_green)


Case Else
If $x = 0 Or $y = 0 Or $x = $worldWidth - 1 Or $y = $worldHeight - 1 Then ;rand einfärben
$data_map[$x][$y] = "x"
_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_black)

Else
$data_map[$x][$y] = "0"
_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_gray)

EndIf

EndSwitch

;If $x = 2 and $y = 2 Then MsgBox($MB_SYSTEMMODAL, "Title", "$open[$y * $worldWidth + $x]="&$open[$y * $worldWidth + $x]&"     $y * $worldWidth + $x="&$y * $worldWidth + $x&" $x="&$x&" $y="&$y, 0)

ElseIf $tiled_map0 = 0 Then
If $x = 0 Or $y = 0 Or $x = $worldWidth - 1 Or $y = $worldHeight - 1 Then ;rand einfärben
$data_map[$x][$y] = "x"
_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_black)


Else
;$data_map[$x][$y] = "x"
;_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_black)

$data_map[$x][$y] = "0"
_GDIPlus_GraphicsFillRect($hGraphic, $x * ($tileWidth + $distance) + $distance, $y * ($tileHeight + $distance) + $distance, $tileWidth, $tileHeight, $Brush_gray)

EndIf
EndIf ; end $tiled_map01 = 1

Next
Next
EndFunc


Func _ArrayCreate($v_0, $v_1 = 0, $v_2 = 0, $v_3 = 0, $v_4 = 0, $v_5 = 0, $v_6 = 0, $v_7 = 0, $v_8 = 0, $v_9 = 0, $v_10 = 0, $v_11 = 0, $v_12 = 0, $v_13 = 0, $v_14 = 0, $v_15 = 0, $v_16 = 0, $v_17 = 0, $v_18 = 0, $v_19 = 0, $v_20 = 0)
    Local $av_Array[21] = [$v_0, $v_1, $v_2, $v_3, $v_4, $v_5, $v_6, $v_7, $v_8, $v_9, $v_10, $v_11, $v_12, $v_13, $v_14, $v_15, $v_16, $v_17, $v_18, $v_19, $v_20]
    ReDim $av_Array[@NumParams]
    Return $av_Array
EndFunc   ;==>_ArrayCreate


;=============================================================================
; Replaces data grid with node objects
; Converts $data into a 2D array of node objects from previous $data array
; consisting of only string characters.
;=============================================================================
Func _CreateMap(ByRef $data, $y, $x) ;converts a 2D array of data to node objects ; dao x y nguoc
	For $i = 0 To $y - 1 ;for each row
		For $j = 0 To $x - 1 ;for each column
			;If StringRegExp($data[$i][$j], "[x,s,g]") <> 1 Then;if not a x,s,g
			   If StringRegExp($data[$i][$j], "[x,s]") <> 1 Then;if not a x,s fix error g
				$data[$i][$j] = _CreateNode($i & "," & $j, "null", 0, $data[$i][$j], 0, $data[$i][$j])
			Else
				If $data[$i][$j] = "s" Then
					$data[$i][$j] = _CreateNode($i & "," & $j, "null", 0, 0, 0, $data[$i][$j])
				Else
					$data[$i][$j] = _CreateNode($i & "," & $j, "null", 0, 1, 0, $data[$i][$j])
				EndIf
			EndIf
		Next
	Next
EndFunc   ;==>_CreateMap
;=============================================================================
; Creates a node struct object with the following parameters
; struct node {
;   char self_coord[8];          // Format = "x,y"
;   char parent_coord[8];        // Format = "x,y"
;   int f;                       // F = G + H
;   int g;                       // G = current cost to this node from start node
;   int h;                       // H = Heuristic cost, this node to goal node
;   char value[8];               // Type of node (ex. "s","g","x","1,2,3..n")
;   int cost;                    // Cost of node (difficulty of traveling on this)
; }
;=============================================================================
Func _CreateNode($self, $parent, $f, $g, $h, $value) ;returns struct object
	Local $node[6] = [$self, $parent, $f, $g, $h, $value]
	Return $node
EndFunc   ;==>_CreateNode
;=============================================================================
; Checks to see if start node exists in map
; Returns an array: [y,x]
;=============================================================================
Func _GetStartingLocation(ByRef $data, $cols, $rows)
	For $i = 0 To $cols - 1
		For $j = 0 To $rows - 1
			If $data[$i][$j] = "s" Then
				Local $pos[2] = [$j, $i]
				Return $pos
			EndIf
		Next
	Next
	Return 0 ;no starting location found
EndFunc   ;==>_GetStartingLocation
;=============================================================================
; Checks to see if goal node exists in map
; Returns an array: [y,x]
;=============================================================================
Func _GetGoalLocation(ByRef $data, $cols, $rows)
	For $i = 0 To $cols - 1
		For $j = 0 To $rows - 1
			If $data[$i][$j] = "g" Then
				Local $pos[2] = [$j, $i]
				Return $pos
			EndIf
		Next
	Next
	Return 0 ;no starting location found
EndFunc   ;==>_GetGoalLocation
;=============================================================================
; Calculates the manhattan distance between two nodes
; MD = |G(x) - N(x)| + |G(y) - N(x)|
; Returns an integer
;=============================================================================
Func _MD(ByRef $node, ByRef $goal) ;returns integer
	Local $node_coord = StringSplit($node[0], ",") ;current node
	Local $goal_coord = StringSplit($goal[0], ",") ;goal node
	Return (Abs($goal_coord[1] - $node_coord[1]) + Abs($goal_coord[2] - $node_coord[2])) * $estimate
EndFunc   ;==>_MD
;=============================================================================
; Calculates the Euclidean distance between two nodes
; MD = SquareRoot ( (G(x) - N(x))^2 + (G(y) - N(x))^2 )
; Returns an integer
;=============================================================================
Func _ED(ByRef $node, ByRef $goal) ;returns integer
	Local $node_coord = StringSplit($node[0], ",") ;current node
	Local $goal_coord = StringSplit($goal[0], ",") ;goal node
	Return Sqrt(($goal_coord[1] - $node_coord[1]) ^ 2 + ($goal_coord[2] - $node_coord[2]) ^ 2) * $estimate
EndFunc   ;==>_ED
;=============================================================================
; A * Searching Algorithm
; Keep searching nodes until the goal is found.
; Returns: Array if path found
; Returns: 0 if no path
;=============================================================================
Func _FindPath(ByRef $map, $start_node, $goal_node) ;returns array of coords
	Local $openlist = _ArrayCreate("empty") ;start with empty open list
	Local $closedlist = _ArrayCreate("empty") ;start with empty closed list
	Local $current_node = $start_node ;set current node to start nodeF
	$closedList_Str &= $current_node[0] & "_"
	$openList_Str &= $current_node[0] & "_"
	_AddAdjacents_Openlist($map, $openlist, $closedlist, $current_node, $goal_node) ;add all possible adjacents to openlist
	While 1 ;while goal is not in closed list, or open list is not empty
		If UBound($openlist) = 1 Then ExitLoop ;if open list is empty then no path found
		$current_node = _GetLowest_F_Cost_Node($openlist) ;pick node with lowest F cost
		$closedList_Str &= $current_node[0] & "_"
		_AddAdjacents_Openlist($map, $openlist, $closedlist, $current_node, $goal_node) ;add all possible adjacents to openlist
		If $current_node[0] = $goal_node[0] Then ExitLoop ;if current node is goal then path is found!
	WEnd
	If _IsInClosedList($goal_node[0]) = 0 Then ;if no goal found then return 0
		Return 0 ; no path found
	Else
		Return _GetPath($map, $current_node, $start_node) ;return array of coords (x,y) in string format
	EndIf
EndFunc   ;==>_FindPath
;=============================================================================
; Returns node object with the lowest F cost
; F = G + H
; Returns 0 with openlist is emtpy, there is no path
;=============================================================================
Func _GetLowest_F_Cost_Node(ByRef $openlist)
	If UBound($openlist) > 1 Then ;If open list is not empty
		Local $obj = $openlist[1] ;Pop first item in the queue
		_ArrayDelete($openlist, 1) ;remove this node from openlist
		Return $obj ;return lowest F cost node
	EndIf
	Return 0 ;openlist is empty
EndFunc   ;==>_GetLowest_F_Cost_Node
;=============================================================================
; Start from goal node and traverse each parent node until starting node is
; reached.
; Each node will have a parent node (use this to get path bot will take)
; Returns: Array of coords, first index is starting location
;=============================================================================
Func _GetPath(ByRef $data, ByRef $ending_node, ByRef $start_node)
	Local $path = _ArrayCreate($ending_node[0]) ;start from goal node
	Local $node_coord = StringSplit($path[0], ",")
	Local $x = $node_coord[1]
	Local $y = $node_coord[2]
	Local $start = $start_node[0] ;starting nodes coord
	Local $obj = $data[$x][$y] ;current node starting from the goal
	While $obj[1] <> $start ;keep adding until reached starting node
		_Add_List($path, $y & "," & $x) ;add the parent node to the list
		$obj = $data[$x][$y] ;get node from 2D data array
		$node_coord = StringSplit($obj[1], ",")
		If $node_coord[0] = 1 Then ExitLoop
		$x = $node_coord[1]
		$y = $node_coord[2]
	WEnd
	_ArrayDelete($path, 0) ;no need to starting node
	_ArrayReverse($path) ;flip array to make starting node at index 0
	Return $path ;return path as array in "x,y" format for each item
EndFunc   ;==>_GetPath
;=============================================================================
; Adds adjacent nodes to the open list if:
; 1. Node is not a barrier "x"
; 2. Node is not in open list
; 3. Node is not in closed list
; Set newly added node's parent to the current node and update its F,G, and H
; Only need to check North, South, East and West nodes.
;=============================================================================
Func _AddAdjacents_Openlist(ByRef $data, ByRef $openlist, ByRef $closedlist, ByRef $node, ByRef $goal)
	Local $current_coord = StringSplit($node[0], ",")
	Local $x = $current_coord[1]
	Local $y = $current_coord[2]
	Local $h ; heuristic
	Local $north = 0
	Local $south = 0
	Local $east = 0
	Local $west = 0
	Local $obj = $data[$x][$y - 1]
	If $obj[5] <> "x" And _ ;north
			Not _IsInAnyList($obj[0]) Then ;If not in closed list or openlist and is not a barrier
		If $heuristic = 1 Then
			$h = _MD($obj, $goal)
		Else
			$h = _ED($obj, $goal)
		EndIf
		$obj[1] = $node[0] ;set nodes parent to last node
		$obj[3] = $node[3] + $obj[3] ;set g score (current node's G score + adjacent node's G score)
		$obj[2] = $obj[3] + $h ;set f = g + h score
		$data[$x][$y - 1] = $obj
		$north = 1
		$openList_Str &= $obj[0] & "_"
		_Insert_PQ($openlist, $obj)
	EndIf
	$obj = $data[$x][$y + 1]
	If $obj[5] <> "x" And _ ;south
			Not _IsInAnyList($obj[0]) Then
		If $heuristic = 1 Then
			$h = _MD($obj, $goal)
		Else
			$h = _ED($obj, $goal)
		EndIf
		$obj[1] = $node[0] ;set nodes parent to last node
		$obj[3] = $node[3] + $obj[3]  ;set g score (current node's G score + adjacent node's G score)
		$obj[2] = $obj[3] + $h ;set f = g + h score
		$data[$x][$y + 1] = $obj
		$south = 1
		$openList_Str &= $obj[0] & "_"
		_Insert_PQ($openlist, $obj)
	EndIf
	$obj = $data[$x + 1][$y]
	If $obj[5] <> "x" And _ ;east
			Not _IsInAnyList($obj[0]) Then
		If $heuristic = 1 Then
			$h = _MD($obj, $goal)
		Else
			$h = _ED($obj, $goal)
		EndIf
		$obj[1] = $node[0] ;set nodes parent to last node
		$obj[3] = $node[3] + $obj[3]  ;set g score (current node's G score + adjacent node's G score)
		$obj[2] = $obj[3] + $h ;set f = g + h score
		$data[$x + 1][$y] = $obj
		$east = 1
		$openList_Str &= $obj[0] & "_"
		_Insert_PQ($openlist, $obj)
	EndIf
	$obj = $data[$x - 1][$y]
	If $obj[5] <> "x" And _ ;west
			Not _IsInAnyList($obj[0]) Then
		If $heuristic = 1 Then
			$h = _MD($obj, $goal)
		Else
			$h = _ED($obj, $goal)
		EndIf
		$obj[1] = $node[0] ;set nodes parent to last node
		$obj[3] = $node[3] + $obj[3]  ;set g score (current node's G score + adjacent node's G score)
		$obj[2] = $obj[3] + $h ;set f = g + h score
		$data[$x - 1][$y] = $obj
		$west = 1
		$openList_Str &= $obj[0] & "_"
		_Insert_PQ($openlist, $obj)
	EndIf
	;diagonals moves
	If $allow_diagonals_Boolean Then ;if GUI checkbox is checked, then check other 4 directions
		If $north + $east = 2 Then ;Not allowed to cut around corners, not realistic
			$obj = $data[$x + 1][$y - 1]
			If $obj[5] <> "x" And _ ;northeast
					Not _IsInAnyList($obj[0]) Then
				If $heuristic = 1 Then
					$h = _MD($obj, $goal)
				Else
					$h = _ED($obj, $goal)
				EndIf
				$obj[1] = $node[0] ;set nodes parent to last node
				$obj[3] = $node[3] + (Sqrt(2) * $obj[3])  ;set g score (current node's G score + adjacent node's G score* Sqrt(2))
				$obj[2] = $obj[3] + $h ;set f = g + h score
				$data[$x + 1][$y - 1] = $obj
				$openList_Str &= $obj[0] & "_"
				_Insert_PQ($openlist, $obj)
			EndIf
		EndIf
		If $north + $west = 2 Then
			$obj = $data[$x - 1][$y - 1]
			If $obj[5] <> "x" And _ ;north west
					Not _IsInAnyList($obj[0]) Then
				If $heuristic = 1 Then
					$h = _MD($obj, $goal)
				Else
					$h = _ED($obj, $goal)
				EndIf
				$obj[1] = $node[0] ;set nodes parent to last node
				$obj[3] = $node[3] + (Sqrt(2) * $obj[3])  ;set g score (current node's G score + adjacent node's G score* Sqrt(2))
				$obj[2] = $obj[3] + $h  ;set f = g + h score
				$data[$x - 1][$y - 1] = $obj
				$openList_Str &= $obj[0] & "_"
				_Insert_PQ($openlist, $obj)
			EndIf
		EndIf
		If $south + $east = 2 Then
			$obj = $data[$x + 1][$y + 1]
			If $obj[5] <> "x" And _ ;southeast
					Not _IsInAnyList($obj[0]) Then
				If $heuristic = 1 Then
					$h = _MD($obj, $goal)
				Else
					$h = _ED($obj, $goal)
				EndIf
				$obj[1] = $node[0] ;set nodes parent to last node
				$obj[3] = $node[3] + (Sqrt(2) * $obj[3])  ;set g score (current node's G score + adjacent node's G score)
				$obj[2] = $obj[3] + $h  ;set f = g + h score
				$data[$x + 1][$y + 1] = $obj
				$openList_Str &= $obj[0] & "_"
				_Insert_PQ($openlist, $obj)
			EndIf
		EndIf
		If $south + $west = 2 Then
			$obj = $data[$x - 1][$y + 1]
			If $obj[5] <> "x" And _ ;southwest
					Not _IsInAnyList($obj[0]) Then
				If $heuristic = 1 Then
					$h = _MD($obj, $goal)
				Else
					$h = _ED($obj, $goal)
				EndIf
				$obj[1] = $node[0] ;set nodes parent to last node
				$obj[3] = $node[3] + (Sqrt(2) * $obj[3])  ;set g score (current node's G score + adjacent node's G score)
				$obj[2] = $obj[3] + $h  ;set f = g + h score
				$data[$x - 1][$y + 1] = $obj
				$openList_Str &= $obj[0] & "_"
				_Insert_PQ($openlist, $obj)
			EndIf
		EndIf
	EndIf
EndFunc   ;==>_AddAdjacents_Openlist
;=============================================================================
; Returns true if node is in closed list
; Search the list backwards, its faster
;=============================================================================
Func _IsInClosedList(ByRef $node)
	If StringRegExp($closedList_Str, "_" & $node & "_") Then
		Return 1
	Else
		Return 0
	EndIf
EndFunc   ;==>_IsInClosedList
;=============================================================================
; Returns true if node is in open list
; Regular expressions are used rather than searching an array list for speed.
;=============================================================================
Func _IsInAnyList(ByRef $node)
	If StringRegExp($openList_Str, "_" & $node & "_") Then
		Return 1
	Else
		Return 0
	EndIf
EndFunc   ;==>_IsInAnyList
;=============================================================================
; Inserts object into openlist and preserves ascending order
; This way will result in a priority queue with the lowest F cost at
; position 1 in the openlist array.
;=============================================================================
Func _Insert_PQ(ByRef $openlist, $node)
	Local $obj
	For $i = 1 To UBound($openlist) - 1
		Local $obj = $openlist[$i]
		If $node[2] < $obj[2] Then
			_ArrayInsert($openlist, $i, $node)
			Return
		EndIf
	Next
	_Add_List($openlist, $node)
EndFunc   ;==>_Insert_PQ
;=============================================================================
; Adds nodes the a list
;=============================================================================
Func _Add_List(ByRef $list, $node)
	ReDim $list[UBound($list) + 1]
	$list[UBound($list) - 1] = $node
EndFunc   ;==>_Add_List
;============================================================================
; End of Algorithm
;============================================================================


Func _IsChecked($idControlID)
    Return BitAND(GUICtrlRead($idControlID), $GUI_CHECKED) = $GUI_CHECKED
 EndFunc   ;==>_IsChecked

