#include <array.au3>

Local $Win_Max_Number = 4
Local $Key_Forward = "{PAUSE}"
Local $Key_Backward = "{HOME}"
Local $Window_Array[5][25]
Local $Window_Current_Arr = 1
Local $Window_Current_Active = 1

Local $Dll_User_32 = DllOpen("user32.dll")
HotKeySet($Key_Forward, "_ScreenForward")
HotKeySet($Key_Backward, "_ScreenBackward")

_GenerateWindowArray()

While 1

    Sleep(50)
    _UpdateWindowArray()

WEnd

Func _GenerateWindowArray()

    $var = WinList()
    For $i = 1 To $var[0][0]
        If $var[$i][0] <> "" And IsVisible($var[$i][1]) Then
            $Window_Array[$Window_Current_Active][$Window_Current_Arr] = $var[$i][1]
            $Window_Current_Arr += 1
        EndIf
    Next

EndFunc   ;==>_GenerateWindowArray

Func _UpdateWindowArray()

    For $x = 1 to 4
        For $i = 1 to 24
            If not WinExists ($Window_Array[$x][$i]) Then
                $Window_Array[$x][$i] = ""
                $Window_Current_Arr -= 1
            EndIf
        Next
    Next

    $var = WinList()
    For $i = 1 To $var[0][0]
        If $var[$i][0] <> "" And IsVisible($var[$i][1]) Then
            If _ArraySearch($Window_Array, $var[$i][1]) = -1 Then
                $Window_Array[$Window_Current_Active][$Window_Current_Arr] = $var[$i][1]
                $Window_Current_Arr += 1
            EndIf
        EndIf
    Next

EndFunc

Func _ScreenForward()

    If $Window_Current_Active < $Win_Max_Number Then
        $Window_Current_Active += 1
        ConsoleWrite ("Screen #: " & $Window_Current_Active & @CRLF)

        For $i = 1 to 24
            If $Window_Array[$Window_Current_Active-1][$i] <> "" Then
                _SetWindowState($Window_Array[$Window_Current_Active-1][$i], 0)
            EndIf
        Next

        For $i = 1 to 24
        If $Window_Array[$Window_Current_Active][$i] <> "" Then
                _SetWindowState($Window_Array[$Window_Current_Active][$i], 1)
            EndIf
        Next

    EndIf

EndFunc   ;==>_ScreenForward

Func _ScreenBackward()

    If $Window_Current_Active > 1 Then
        $Window_Current_Active -= 1
        ConsoleWrite ("Screen #: " & $Window_Current_Active & @CRLF)

        For $i = 1 to 24
            If $Window_Array[$Window_Current_Active+1][$i] <> "" Then
                _SetWindowState($Window_Array[$Window_Current_Active+1][$i], 0)
            EndIf
        Next

        For $i = 1 to 24
        If $Window_Array[$Window_Current_Active][$i] <> "" Then
                _SetWindowState($Window_Array[$Window_Current_Active][$i], 1)
            EndIf
        Next

    EndIf

EndFunc   ;==>_ScreenBackward

Func _SetWindowState($hWnd, $sCode)

    DllCall($Dll_User_32, "bool", "ShowWindow", "HWND", $hWnd, "int", $sCode)

EndFunc   ;==>_SetWindowState

Func IsVisible($handle)

    If BitAND(WinGetState($handle), 2) Then
        Return 1
    Else
        Return 0
    EndIf

EndFunc   ;==>IsVisible